import type { Config as CoreConfig } from "@ionic/core/components";
import { LIFECYCLE_DID_ENTER, LIFECYCLE_DID_LEAVE, LIFECYCLE_WILL_ENTER, LIFECYCLE_WILL_LEAVE } from "@ionic/core/components";
import type { Ref, ComponentPublicInstance } from "vue";
declare type LIFECYCLE_EVENTS = typeof LIFECYCLE_WILL_ENTER | typeof LIFECYCLE_DID_ENTER | typeof LIFECYCLE_WILL_LEAVE | typeof LIFECYCLE_DID_LEAVE;
export declare enum LifecycleHooks {
    WillEnter = "onIonViewWillEnter",
    DidEnter = "onIonViewDidEnter",
    WillLeave = "onIonViewWillLeave",
    DidLeave = "onIonViewDidLeave"
}
export declare const generateId: (type?: string) => string;
export declare const fireLifecycle: (vueComponent: any, vueInstance: Ref<ComponentPublicInstance>, lifecycle: LIFECYCLE_EVENTS) => void;
export declare const getConfig: () => CoreConfig | null;
export {};
