import type { AnimationBuilder } from "../";
export declare type RouteAction = "push" | "pop" | "replace";
export declare type RouteDirection = "forward" | "back" | "root" | "none";
export interface UseIonRouterResult {
    /**
     * The location parameter is really of type 'RouteLocationRaw'
     * imported from vue-router, but the @ionic/vue package should
     * not have a hard dependency on vue-router, so we just use 'any'.
     */
    canGoBack: (deep?: number) => boolean;
    push: (location: any, routerAnimation?: AnimationBuilder) => void;
    replace: (location: any, routerAnimation?: AnimationBuilder) => void;
    back: (routerAnimation?: AnimationBuilder) => void;
    forward: (routerAnimation?: AnimationBuilder) => void;
    navigate: (location: any, routerDirection?: RouteDirection, routerAction?: RouteAction, routerAnimation?: AnimationBuilder) => void;
}
/**
 * Used to navigate within Vue Router
 * while controlling the animation.
 */
export declare const useIonRouter: () => UseIonRouterResult;
