/*!
 * (C) Ionic http://ionicframework.com - MIT License
 */
import { expect } from "@playwright/test";
import { configs, test } from "../../../../utils/test/playwright/index";
configs().forEach(({ title, screenshot, config }) => {
    test.describe(title('item: lines'), () => {
        test('should not have visual regressions', async ({ page }) => {
            await page.goto(`/src/components/item/test/lines`, config);
            await page.setIonViewport();
            await expect(page).toHaveScreenshot(screenshot(`item-lines-diff`));
        });
    });
});
