/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.localnotifications;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.app.RemoteInput;
import com.capacitorjs.plugins.localnotifications.DateMatch;
import com.capacitorjs.plugins.localnotifications.LocalNotification;
import com.capacitorjs.plugins.localnotifications.LocalNotificationSchedule;
import com.capacitorjs.plugins.localnotifications.LocalNotificationsPlugin;
import com.capacitorjs.plugins.localnotifications.NotificationAction;
import com.capacitorjs.plugins.localnotifications.NotificationDismissReceiver;
import com.capacitorjs.plugins.localnotifications.NotificationStorage;
import com.capacitorjs.plugins.localnotifications.R;
import com.capacitorjs.plugins.localnotifications.TimedNotificationPublisher;
import com.getcapacitor.CapConfig;
import com.getcapacitor.JSObject;
import com.getcapacitor.Logger;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginConfig;
import com.getcapacitor.plugin.util.AssetUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class LocalNotificationManager {
    private static int defaultSoundID = 0;
    private static int defaultSmallIconID = 0;
    public static final String NOTIFICATION_INTENT_KEY = "LocalNotificationId";
    public static final String NOTIFICATION_OBJ_INTENT_KEY = "LocalNotficationObject";
    public static final String ACTION_INTENT_KEY = "LocalNotificationUserAction";
    public static final String NOTIFICATION_IS_REMOVABLE_KEY = "LocalNotificationRepeating";
    public static final String REMOTE_INPUT_KEY = "LocalNotificationRemoteInput";
    public static final String DEFAULT_NOTIFICATION_CHANNEL_ID = "default";
    private static final String DEFAULT_PRESS_ACTION = "tap";
    private Context context;
    private Activity activity;
    private NotificationStorage storage;
    private PluginConfig config;

    public LocalNotificationManager(NotificationStorage notificationStorage, Activity activity, Context context, CapConfig config) {
        this.storage = notificationStorage;
        this.activity = activity;
        this.context = context;
        this.config = config.getPluginConfiguration("LocalNotifications");
    }

    public JSObject handleNotificationActionPerformed(Intent data, NotificationStorage notificationStorage) {
        Logger.debug((String)Logger.tags((String[])new String[]{"LN"}), (String)("LocalNotification received: " + data.getDataString()));
        int notificationId = data.getIntExtra(NOTIFICATION_INTENT_KEY, Integer.MIN_VALUE);
        if (notificationId == Integer.MIN_VALUE) {
            Logger.debug((String)Logger.tags((String[])new String[]{"LN"}), (String)"Activity started without notification attached");
            return null;
        }
        boolean isRemovable = data.getBooleanExtra(NOTIFICATION_IS_REMOVABLE_KEY, true);
        if (isRemovable) {
            notificationStorage.deleteNotification(Integer.toString(notificationId));
        }
        JSObject dataJson = new JSObject();
        Bundle results = RemoteInput.getResultsFromIntent((Intent)data);
        if (results != null) {
            CharSequence input = results.getCharSequence(REMOTE_INPUT_KEY);
            dataJson.put("inputValue", input.toString());
        }
        String menuAction = data.getStringExtra(ACTION_INTENT_KEY);
        this.dismissVisibleNotification(notificationId);
        dataJson.put("actionId", menuAction);
        JSObject request = null;
        try {
            String notificationJsonString = data.getStringExtra(NOTIFICATION_OBJ_INTENT_KEY);
            if (notificationJsonString != null) {
                request = new JSObject(notificationJsonString);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        dataJson.put("notification", request);
        return dataJson;
    }

    public void createNotificationChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            String name = "Default";
            String description = "Default";
            int importance = 3;
            NotificationChannel channel = new NotificationChannel(DEFAULT_NOTIFICATION_CHANNEL_ID, (CharSequence)name, importance);
            channel.setDescription(description);
            AudioAttributes audioAttributes = new AudioAttributes.Builder().setContentType(4).setUsage(4).build();
            Uri soundUri = this.getDefaultSoundUrl(this.context);
            if (soundUri != null) {
                channel.setSound(soundUri, audioAttributes);
            }
            NotificationManager notificationManager = (NotificationManager)this.context.getSystemService(NotificationManager.class);
            notificationManager.createNotificationChannel(channel);
        }
    }

    @Nullable
    public JSONArray schedule(PluginCall call, List<LocalNotification> localNotifications) {
        JSONArray ids = new JSONArray();
        NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)this.context);
        boolean notificationsEnabled = notificationManager.areNotificationsEnabled();
        if (!notificationsEnabled) {
            if (call != null) {
                call.reject("Notifications not enabled on this device");
            }
            return null;
        }
        for (LocalNotification localNotification : localNotifications) {
            Integer id = localNotification.getId();
            if (localNotification.getId() == null) {
                if (call != null) {
                    call.reject("LocalNotification missing identifier");
                }
                return null;
            }
            this.dismissVisibleNotification(id);
            this.cancelTimerForNotification(id);
            this.buildNotification(notificationManager, localNotification, call);
            ids.put((Object)id);
        }
        return ids;
    }

    private void buildNotification(NotificationManagerCompat notificationManager, LocalNotification localNotification, PluginCall call) {
        String sound;
        String channelId = DEFAULT_NOTIFICATION_CHANNEL_ID;
        if (localNotification.getChannelId() != null) {
            channelId = localNotification.getChannelId();
        }
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context, channelId).setContentTitle((CharSequence)localNotification.getTitle()).setContentText((CharSequence)localNotification.getBody()).setAutoCancel(localNotification.isAutoCancel()).setOngoing(localNotification.isOngoing()).setPriority(0).setGroupSummary(localNotification.isGroupSummary());
        if (localNotification.getLargeBody() != null) {
            mBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)localNotification.getLargeBody()).setSummaryText((CharSequence)localNotification.getSummaryText()));
        }
        if (localNotification.getInboxList() != null) {
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            for (String line : localNotification.getInboxList()) {
                inboxStyle.addLine((CharSequence)line);
            }
            inboxStyle.setBigContentTitle((CharSequence)localNotification.getTitle());
            inboxStyle.setSummaryText((CharSequence)localNotification.getSummaryText());
            mBuilder.setStyle((NotificationCompat.Style)inboxStyle);
        }
        if ((sound = localNotification.getSound(this.context, this.getDefaultSound(this.context))) != null) {
            Uri soundUri = Uri.parse((String)sound);
            this.context.grantUriPermission("com.android.systemui", soundUri, 1);
            mBuilder.setSound(soundUri);
            mBuilder.setDefaults(6);
        } else {
            mBuilder.setDefaults(-1);
        }
        String group = localNotification.getGroup();
        if (group != null) {
            mBuilder.setGroup(group);
            if (localNotification.isGroupSummary()) {
                mBuilder.setSubText((CharSequence)localNotification.getSummaryText());
            }
        }
        mBuilder.setVisibility(0);
        mBuilder.setOnlyAlertOnce(true);
        mBuilder.setSmallIcon(localNotification.getSmallIcon(this.context, this.getDefaultSmallIcon(this.context)));
        mBuilder.setLargeIcon(localNotification.getLargeIcon(this.context));
        String iconColor = localNotification.getIconColor(this.config.getString("iconColor"));
        if (iconColor != null) {
            try {
                mBuilder.setColor(Color.parseColor((String)iconColor));
            }
            catch (IllegalArgumentException ex) {
                if (call != null) {
                    call.reject("Invalid color provided. Must be a hex string (ex: #ff0000");
                }
                return;
            }
        }
        this.createActionIntents(localNotification, mBuilder);
        Notification buildNotification = mBuilder.build();
        if (localNotification.isScheduled()) {
            this.triggerScheduledNotification(buildNotification, localNotification);
        } else {
            try {
                JSObject notificationJson = new JSObject(localNotification.getSource());
                LocalNotificationsPlugin.fireReceived(notificationJson);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            notificationManager.notify(localNotification.getId().intValue(), buildNotification);
        }
    }

    private void createActionIntents(LocalNotification localNotification, NotificationCompat.Builder mBuilder) {
        Intent intent = this.buildIntent(localNotification, DEFAULT_PRESS_ACTION);
        int flags = 0x10000000;
        if (Build.VERSION.SDK_INT >= 31) {
            flags |= 0x2000000;
        }
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.context, (int)localNotification.getId(), (Intent)intent, (int)flags);
        mBuilder.setContentIntent(pendingIntent);
        String actionTypeId = localNotification.getActionTypeId();
        if (actionTypeId != null) {
            NotificationAction[] actionGroup;
            for (NotificationAction notificationAction : actionGroup = this.storage.getActionGroup(actionTypeId)) {
                Intent actionIntent = this.buildIntent(localNotification, notificationAction.getId());
                PendingIntent actionPendingIntent = PendingIntent.getActivity((Context)this.context, (int)(localNotification.getId() + notificationAction.getId().hashCode()), (Intent)actionIntent, (int)flags);
                NotificationCompat.Action.Builder actionBuilder = new NotificationCompat.Action.Builder(R.drawable.ic_transparent, (CharSequence)notificationAction.getTitle(), actionPendingIntent);
                if (notificationAction.isInput()) {
                    RemoteInput remoteInput = new RemoteInput.Builder(REMOTE_INPUT_KEY).setLabel((CharSequence)notificationAction.getTitle()).build();
                    actionBuilder.addRemoteInput(remoteInput);
                }
                mBuilder.addAction(actionBuilder.build());
            }
        }
        Intent dissmissIntent = new Intent(this.context, NotificationDismissReceiver.class);
        dissmissIntent.setFlags(0x10008000);
        dissmissIntent.putExtra(NOTIFICATION_INTENT_KEY, (Serializable)localNotification.getId());
        dissmissIntent.putExtra(ACTION_INTENT_KEY, "dismiss");
        LocalNotificationSchedule schedule = localNotification.getSchedule();
        dissmissIntent.putExtra(NOTIFICATION_IS_REMOVABLE_KEY, schedule == null || schedule.isRemovable());
        flags = 0;
        if (Build.VERSION.SDK_INT >= 31) {
            flags = 0x2000000;
        }
        PendingIntent deleteIntent = PendingIntent.getBroadcast((Context)this.context, (int)localNotification.getId(), (Intent)dissmissIntent, (int)flags);
        mBuilder.setDeleteIntent(deleteIntent);
    }

    @NonNull
    private Intent buildIntent(LocalNotification localNotification, String action) {
        Intent intent;
        if (this.activity != null) {
            intent = new Intent(this.context, this.activity.getClass());
        } else {
            String packageName = this.context.getPackageName();
            intent = this.context.getPackageManager().getLaunchIntentForPackage(packageName);
        }
        intent.setAction("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.setFlags(0x24000000);
        intent.putExtra(NOTIFICATION_INTENT_KEY, (Serializable)localNotification.getId());
        intent.putExtra(ACTION_INTENT_KEY, action);
        intent.putExtra(NOTIFICATION_OBJ_INTENT_KEY, localNotification.getSource());
        LocalNotificationSchedule schedule = localNotification.getSchedule();
        intent.putExtra(NOTIFICATION_IS_REMOVABLE_KEY, schedule == null || schedule.isRemovable());
        return intent;
    }

    private void triggerScheduledNotification(Notification notification, LocalNotification request) {
        AlarmManager alarmManager = (AlarmManager)this.context.getSystemService("alarm");
        LocalNotificationSchedule schedule = request.getSchedule();
        Intent notificationIntent = new Intent(this.context, TimedNotificationPublisher.class);
        notificationIntent.putExtra(NOTIFICATION_INTENT_KEY, (Serializable)request.getId());
        notificationIntent.putExtra(TimedNotificationPublisher.NOTIFICATION_KEY, (Parcelable)notification);
        int flags = 0x10000000;
        if (Build.VERSION.SDK_INT >= 31) {
            flags |= 0x2000000;
        }
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)request.getId(), (Intent)notificationIntent, (int)flags);
        Date at = schedule.getAt();
        if (at != null) {
            if (at.getTime() < new Date().getTime()) {
                Logger.error((String)Logger.tags((String[])new String[]{"LN"}), (String)"Scheduled time must be *after* current time", null);
                return;
            }
            if (schedule.isRepeating()) {
                long interval = at.getTime() - new Date().getTime();
                alarmManager.setRepeating(1, at.getTime(), interval, pendingIntent);
            } else {
                this.setExactIfPossible(alarmManager, schedule, at.getTime(), pendingIntent);
            }
            return;
        }
        String every = schedule.getEvery();
        if (every != null) {
            Long everyInterval = schedule.getEveryInterval();
            if (everyInterval != null) {
                long startTime = new Date().getTime() + everyInterval;
                alarmManager.setRepeating(1, startTime, everyInterval.longValue(), pendingIntent);
            }
            return;
        }
        DateMatch on = schedule.getOn();
        if (on != null) {
            long trigger = on.nextTrigger(new Date());
            notificationIntent.putExtra(TimedNotificationPublisher.CRON_KEY, on.toMatchString());
            pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)request.getId(), (Intent)notificationIntent, (int)flags);
            this.setExactIfPossible(alarmManager, schedule, trigger, pendingIntent);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Logger.debug((String)Logger.tags((String[])new String[]{"LN"}), (String)("notification " + request.getId() + " will next fire at " + sdf.format(new Date(trigger))));
        }
    }

    private void setExactIfPossible(AlarmManager alarmManager, LocalNotificationSchedule schedule, long trigger, PendingIntent pendingIntent) {
        if (Build.VERSION.SDK_INT >= 31 && !alarmManager.canScheduleExactAlarms()) {
            Logger.warn((String)"Capacitor/LocalNotification", (String)"Exact alarms not allowed in user settings.  Notification scheduled with non-exact alarm.");
            if (Build.VERSION.SDK_INT >= 23 && schedule.allowWhileIdle()) {
                alarmManager.setAndAllowWhileIdle(0, trigger, pendingIntent);
            } else {
                alarmManager.set(1, trigger, pendingIntent);
            }
        } else if (Build.VERSION.SDK_INT >= 23 && schedule.allowWhileIdle()) {
            alarmManager.setExactAndAllowWhileIdle(0, trigger, pendingIntent);
        } else {
            alarmManager.setExact(1, trigger, pendingIntent);
        }
    }

    public void cancel(PluginCall call) {
        List<Integer> notificationsToCancel = LocalNotification.getLocalNotificationPendingList(call);
        if (notificationsToCancel != null) {
            for (Integer id : notificationsToCancel) {
                this.dismissVisibleNotification(id);
                this.cancelTimerForNotification(id);
                this.storage.deleteNotification(Integer.toString(id));
            }
        }
        call.resolve();
    }

    private void cancelTimerForNotification(Integer notificationId) {
        PendingIntent pi;
        Intent intent = new Intent(this.context, TimedNotificationPublisher.class);
        int flags = 0;
        if (Build.VERSION.SDK_INT >= 31) {
            flags = 0x2000000;
        }
        if ((pi = PendingIntent.getBroadcast((Context)this.context, (int)notificationId, (Intent)intent, (int)flags)) != null) {
            AlarmManager alarmManager = (AlarmManager)this.context.getSystemService("alarm");
            alarmManager.cancel(pi);
        }
    }

    private void dismissVisibleNotification(int notificationId) {
        NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)this.context);
        notificationManager.cancel(notificationId);
    }

    public boolean areNotificationsEnabled() {
        NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)this.context);
        return notificationManager.areNotificationsEnabled();
    }

    public Uri getDefaultSoundUrl(Context context) {
        int soundId = this.getDefaultSound(context);
        if (soundId != 0) {
            return Uri.parse((String)("android.resource://" + context.getPackageName() + "/" + soundId));
        }
        return null;
    }

    private int getDefaultSound(Context context) {
        if (defaultSoundID != 0) {
            return defaultSoundID;
        }
        int resId = 0;
        String soundConfigResourceName = this.config.getString("sound");
        if ((soundConfigResourceName = AssetUtil.getResourceBaseName((String)soundConfigResourceName)) != null) {
            resId = AssetUtil.getResourceID((Context)context, (String)soundConfigResourceName, (String)"raw");
        }
        defaultSoundID = resId;
        return resId;
    }

    private int getDefaultSmallIcon(Context context) {
        if (defaultSmallIconID != 0) {
            return defaultSmallIconID;
        }
        int resId = 0;
        String smallIconConfigResourceName = this.config.getString("smallIcon");
        if ((smallIconConfigResourceName = AssetUtil.getResourceBaseName((String)smallIconConfigResourceName)) != null) {
            resId = AssetUtil.getResourceID((Context)context, (String)smallIconConfigResourceName, (String)"drawable");
        }
        if (resId == 0) {
            resId = 17301659;
        }
        defaultSmallIconID = resId;
        return resId;
    }
}

