/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.keyboard;

import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsAnimationCompat;
import androidx.core.view.WindowInsetsCompat;
import java.util.List;

public class Keyboard {
    private AppCompatActivity activity;
    private View rootView;
    private int usableHeightPrevious;
    private FrameLayout.LayoutParams frameLayoutParams;
    private View mChildOfContent;
    @Nullable
    private KeyboardEventListener keyboardEventListener;
    static final String EVENT_KB_WILL_SHOW = "keyboardWillShow";
    static final String EVENT_KB_DID_SHOW = "keyboardDidShow";
    static final String EVENT_KB_WILL_HIDE = "keyboardWillHide";
    static final String EVENT_KB_DID_HIDE = "keyboardDidHide";

    public void setKeyboardEventListener(@Nullable KeyboardEventListener keyboardEventListener) {
        this.keyboardEventListener = keyboardEventListener;
    }

    public Keyboard(final AppCompatActivity activity, final boolean resizeOnFullScreen) {
        this.activity = activity;
        FrameLayout content = (FrameLayout)activity.getWindow().getDecorView().findViewById(0x1020002);
        this.rootView = content.getRootView();
        ViewCompat.setWindowInsetsAnimationCallback((View)this.rootView, (WindowInsetsAnimationCompat.Callback)new WindowInsetsAnimationCompat.Callback(0){

            @NonNull
            public WindowInsetsCompat onProgress(@NonNull WindowInsetsCompat insets, @NonNull List<WindowInsetsAnimationCompat> runningAnimations) {
                return insets;
            }

            @NonNull
            public WindowInsetsAnimationCompat.BoundsCompat onStart(@NonNull WindowInsetsAnimationCompat animation, @NonNull WindowInsetsAnimationCompat.BoundsCompat bounds) {
                boolean showingKeyboard = ViewCompat.getRootWindowInsets((View)Keyboard.this.rootView).isVisible(WindowInsetsCompat.Type.ime());
                WindowInsetsCompat insets = ViewCompat.getRootWindowInsets((View)Keyboard.this.rootView);
                int imeHeight = insets.getInsets((int)WindowInsetsCompat.Type.ime()).bottom;
                DisplayMetrics dm = activity.getResources().getDisplayMetrics();
                float density = dm.density;
                if (resizeOnFullScreen) {
                    Keyboard.this.possiblyResizeChildOfContent(showingKeyboard);
                }
                if (showingKeyboard) {
                    Keyboard.this.keyboardEventListener.onKeyboardEvent(Keyboard.EVENT_KB_WILL_SHOW, Math.round((float)imeHeight / density));
                } else {
                    Keyboard.this.keyboardEventListener.onKeyboardEvent(Keyboard.EVENT_KB_WILL_HIDE, 0);
                }
                return super.onStart(animation, bounds);
            }

            public void onEnd(@NonNull WindowInsetsAnimationCompat animation) {
                super.onEnd(animation);
                boolean showingKeyboard = ViewCompat.getRootWindowInsets((View)Keyboard.this.rootView).isVisible(WindowInsetsCompat.Type.ime());
                WindowInsetsCompat insets = ViewCompat.getRootWindowInsets((View)Keyboard.this.rootView);
                int imeHeight = insets.getInsets((int)WindowInsetsCompat.Type.ime()).bottom;
                DisplayMetrics dm = activity.getResources().getDisplayMetrics();
                float density = dm.density;
                if (showingKeyboard) {
                    Keyboard.this.keyboardEventListener.onKeyboardEvent(Keyboard.EVENT_KB_DID_SHOW, Math.round((float)imeHeight / density));
                } else {
                    Keyboard.this.keyboardEventListener.onKeyboardEvent(Keyboard.EVENT_KB_DID_HIDE, 0);
                }
            }
        });
        this.mChildOfContent = content.getChildAt(0);
        this.frameLayoutParams = (FrameLayout.LayoutParams)this.mChildOfContent.getLayoutParams();
    }

    public void show() {
        ((InputMethodManager)this.activity.getSystemService("input_method")).showSoftInput(this.activity.getCurrentFocus(), 0);
    }

    public boolean hide() {
        InputMethodManager inputManager = (InputMethodManager)this.activity.getSystemService("input_method");
        View v = this.activity.getCurrentFocus();
        if (v == null) {
            return false;
        }
        inputManager.hideSoftInputFromWindow(v.getWindowToken(), 2);
        return true;
    }

    private void possiblyResizeChildOfContent(boolean keyboardShown) {
        int usableHeightNow;
        int n = usableHeightNow = keyboardShown ? this.computeUsableHeight() : -1;
        if (this.usableHeightPrevious != usableHeightNow) {
            this.frameLayoutParams.height = usableHeightNow;
            this.mChildOfContent.requestLayout();
            this.usableHeightPrevious = usableHeightNow;
        }
    }

    private int computeUsableHeight() {
        Rect r = new Rect();
        this.mChildOfContent.getWindowVisibleDisplayFrame(r);
        return this.isOverlays() ? r.bottom : r.height();
    }

    private boolean isOverlays() {
        Window window = this.activity.getWindow();
        return (window.getDecorView().getSystemUiVisibility() & 0x400) == 1024;
    }

    static interface KeyboardEventListener {
        public void onKeyboardEvent(String var1, int var2);
    }
}

