/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.haptics.arguments;

import com.capacitorjs.plugins.haptics.arguments.HapticsVibrationType;

public enum HapticsImpactType implements HapticsVibrationType
{
    LIGHT("LIGHT", new long[]{0L, 50L}, new int[]{0, 110}, new long[]{0L, 20L}),
    MEDIUM("MEDIUM", new long[]{0L, 43L}, new int[]{0, 180}, new long[]{0L, 43L}),
    HEAVY("HEAVY", new long[]{0L, 60L}, new int[]{0, 255}, new long[]{0L, 61L});

    private final String type;
    private final long[] timings;
    private final int[] amplitudes;
    private final long[] oldSDKPattern;

    private HapticsImpactType(String type, long[] timings, int[] amplitudes, long[] oldSDKPattern) {
        this.type = type;
        this.timings = timings;
        this.amplitudes = amplitudes;
        this.oldSDKPattern = oldSDKPattern;
    }

    public static HapticsImpactType fromString(String style) {
        for (HapticsImpactType nt : HapticsImpactType.values()) {
            if (!nt.type.equals(style)) continue;
            return nt;
        }
        return HEAVY;
    }

    @Override
    public long[] getTimings() {
        return this.timings;
    }

    @Override
    public int[] getAmplitudes() {
        return this.amplitudes;
    }

    @Override
    public long[] getOldSDKPattern() {
        return this.oldSDKPattern;
    }
}

