/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.keyboard;

import android.os.Handler;
import android.os.Looper;
import com.capacitorjs.plugins.keyboard.Keyboard;
import com.getcapacitor.JSObject;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginMethod;
import com.getcapacitor.annotation.CapacitorPlugin;

@CapacitorPlugin(name="Keyboard")
public class KeyboardPlugin
extends Plugin {
    private Keyboard implementation;

    public void load() {
        this.execute(() -> {
            boolean resizeOnFullScreen = this.getConfig().getBoolean("resizeOnFullScreen", false);
            this.implementation = new Keyboard(this.getActivity(), resizeOnFullScreen);
            this.implementation.setKeyboardEventListener(this::onKeyboardEvent);
        });
    }

    @PluginMethod
    public void show(PluginCall call) {
        this.execute(() -> new Handler(Looper.getMainLooper()).postDelayed(() -> {
            this.implementation.show();
            call.resolve();
        }, 350L));
    }

    @PluginMethod
    public void hide(PluginCall call) {
        this.execute(() -> {
            if (!this.implementation.hide()) {
                call.reject("Can't close keyboard, not currently focused");
            } else {
                call.resolve();
            }
        });
    }

    @PluginMethod
    public void setAccessoryBarVisible(PluginCall call) {
        call.unimplemented();
    }

    @PluginMethod
    public void setStyle(PluginCall call) {
        call.unimplemented();
    }

    @PluginMethod
    public void setResizeMode(PluginCall call) {
        call.unimplemented();
    }

    @PluginMethod
    public void getResizeMode(PluginCall call) {
        call.unimplemented();
    }

    @PluginMethod
    public void setScroll(PluginCall call) {
        call.unimplemented();
    }

    void onKeyboardEvent(String event, int size) {
        JSObject kbData = new JSObject();
        switch (event) {
            case "keyboardWillShow": 
            case "keyboardDidShow": {
                String data = "{ 'keyboardHeight': " + size + " }";
                this.bridge.triggerWindowJSEvent(event, data);
                kbData.put("keyboardHeight", size);
                this.notifyListeners(event, kbData);
                break;
            }
            case "keyboardWillHide": 
            case "keyboardDidHide": {
                this.bridge.triggerWindowJSEvent(event);
                this.notifyListeners(event, kbData);
            }
        }
    }

    protected void handleOnDestroy() {
        this.implementation.setKeyboardEventListener(null);
    }
}

