/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.statusbar;

import com.capacitorjs.plugins.statusbar.StatusBar;
import com.capacitorjs.plugins.statusbar.StatusBarInfo;
import com.getcapacitor.JSObject;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginMethod;
import com.getcapacitor.annotation.CapacitorPlugin;
import com.getcapacitor.util.WebColor;
import java.util.Locale;

@CapacitorPlugin(name="StatusBar")
public class StatusBarPlugin
extends Plugin {
    private StatusBar implementation;

    public void load() {
        this.implementation = new StatusBar(this.getActivity());
    }

    @PluginMethod
    public void setStyle(PluginCall call) {
        String style = call.getString("style");
        if (style == null) {
            call.reject("Style must be provided");
            return;
        }
        this.getBridge().executeOnMainThread(() -> {
            this.implementation.setStyle(style);
            call.resolve();
        });
    }

    @PluginMethod
    public void setBackgroundColor(PluginCall call) {
        String color = call.getString("color");
        if (color == null) {
            call.reject("Color must be provided");
            return;
        }
        this.getBridge().executeOnMainThread(() -> {
            try {
                int parsedColor = WebColor.parseColor((String)color.toUpperCase(Locale.ROOT));
                this.implementation.setBackgroundColor(parsedColor);
                call.resolve();
            }
            catch (IllegalArgumentException ex) {
                call.reject("Invalid color provided. Must be a hex string (ex: #ff0000");
            }
        });
    }

    @PluginMethod
    public void hide(PluginCall call) {
        this.getBridge().executeOnMainThread(() -> {
            this.implementation.hide();
            call.resolve();
        });
    }

    @PluginMethod
    public void show(PluginCall call) {
        this.getBridge().executeOnMainThread(() -> {
            this.implementation.show();
            call.resolve();
        });
    }

    @PluginMethod
    public void getInfo(PluginCall call) {
        StatusBarInfo info = this.implementation.getInfo();
        JSObject data = new JSObject();
        data.put("visible", info.isVisible());
        data.put("style", info.getStyle());
        data.put("color", info.getColor());
        data.put("overlays", info.isOverlays());
        call.resolve(data);
    }

    @PluginMethod
    public void setOverlaysWebView(PluginCall call) {
        Boolean overlays = call.getBoolean("overlay", Boolean.valueOf(true));
        this.getBridge().executeOnMainThread(() -> {
            this.implementation.setOverlaysWebView(overlays);
            call.resolve();
        });
    }
}

