/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.localnotifications;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.service.notification.StatusBarNotification;
import androidx.activity.result.ActivityResult;
import com.capacitorjs.plugins.localnotifications.LocalNotification;
import com.capacitorjs.plugins.localnotifications.LocalNotificationManager;
import com.capacitorjs.plugins.localnotifications.NotificationAction;
import com.capacitorjs.plugins.localnotifications.NotificationChannelManager;
import com.capacitorjs.plugins.localnotifications.NotificationStorage;
import com.getcapacitor.Bridge;
import com.getcapacitor.JSArray;
import com.getcapacitor.JSObject;
import com.getcapacitor.PermissionState;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginHandle;
import com.getcapacitor.PluginMethod;
import com.getcapacitor.annotation.ActivityCallback;
import com.getcapacitor.annotation.CapacitorPlugin;
import com.getcapacitor.annotation.Permission;
import com.getcapacitor.annotation.PermissionCallback;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@CapacitorPlugin(name="LocalNotifications", permissions={@Permission(strings={"android.permission.POST_NOTIFICATIONS"}, alias="display")})
public class LocalNotificationsPlugin
extends Plugin {
    static final String LOCAL_NOTIFICATIONS = "display";
    private static Bridge staticBridge = null;
    private LocalNotificationManager manager;
    public NotificationManager notificationManager;
    private NotificationStorage notificationStorage;
    private NotificationChannelManager notificationChannelManager;

    public void load() {
        super.load();
        this.notificationStorage = new NotificationStorage(this.getContext());
        this.manager = new LocalNotificationManager(this.notificationStorage, (Activity)this.getActivity(), this.getContext(), this.bridge.getConfig());
        this.manager.createNotificationChannel();
        this.notificationChannelManager = new NotificationChannelManager((Context)this.getActivity());
        this.notificationManager = (NotificationManager)this.getActivity().getSystemService("notification");
        staticBridge = this.bridge;
    }

    protected void handleOnNewIntent(Intent data) {
        super.handleOnNewIntent(data);
        if (!"android.intent.action.MAIN".equals(data.getAction())) {
            return;
        }
        JSObject dataJson = this.manager.handleNotificationActionPerformed(data, this.notificationStorage);
        if (dataJson != null) {
            this.notifyListeners("localNotificationActionPerformed", dataJson, true);
        }
    }

    @PluginMethod
    public void schedule(PluginCall call) {
        List<LocalNotification> localNotifications = LocalNotification.buildNotificationList(call);
        if (localNotifications == null) {
            return;
        }
        JSONArray ids = this.manager.schedule(call, localNotifications);
        if (ids != null) {
            this.notificationStorage.appendNotifications(localNotifications);
            JSObject result = new JSObject();
            JSArray jsArray = new JSArray();
            for (int i = 0; i < ids.length(); ++i) {
                try {
                    JSObject notification = new JSObject().put("id", ids.getInt(i));
                    jsArray.put((Object)notification);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            result.put("notifications", (Object)jsArray);
            call.resolve(result);
        }
    }

    @PluginMethod
    public void cancel(PluginCall call) {
        this.manager.cancel(call);
    }

    @PluginMethod
    public void getPending(PluginCall call) {
        List<LocalNotification> notifications = this.notificationStorage.getSavedNotifications();
        JSObject result = LocalNotification.buildLocalNotificationPendingList(notifications);
        call.resolve(result);
    }

    @PluginMethod
    public void registerActionTypes(PluginCall call) {
        JSArray types = call.getArray("types");
        Map<String, NotificationAction[]> typesArray = NotificationAction.buildTypes(types);
        this.notificationStorage.writeActionGroup(typesArray);
        call.resolve();
    }

    @PluginMethod
    public void areEnabled(PluginCall call) {
        JSObject data = new JSObject();
        data.put("value", this.manager.areNotificationsEnabled());
        call.resolve(data);
    }

    @PluginMethod
    public void getDeliveredNotifications(PluginCall call) {
        JSArray notifications = new JSArray();
        if (Build.VERSION.SDK_INT >= 23) {
            StatusBarNotification[] activeNotifications;
            for (StatusBarNotification notif : activeNotifications = this.notificationManager.getActiveNotifications()) {
                JSObject jsNotif = new JSObject();
                jsNotif.put("id", notif.getId());
                jsNotif.put("tag", notif.getTag());
                Notification notification = notif.getNotification();
                if (notification != null) {
                    jsNotif.put("title", (Object)notification.extras.getCharSequence("android.title"));
                    jsNotif.put("body", (Object)notification.extras.getCharSequence("android.text"));
                    jsNotif.put("group", notification.getGroup());
                    jsNotif.put("groupSummary", 0 != (notification.flags & 0x200));
                    JSObject extras = new JSObject();
                    for (String key : notification.extras.keySet()) {
                        extras.put(key, notification.extras.getString(key));
                    }
                    jsNotif.put("data", (Object)extras);
                }
                notifications.put((Object)jsNotif);
            }
        }
        JSObject result = new JSObject();
        result.put("notifications", (Object)notifications);
        call.resolve(result);
    }

    @PluginMethod
    public void removeDeliveredNotifications(PluginCall call) {
        JSArray notifications = call.getArray("notifications");
        try {
            for (Object o : notifications.toList()) {
                if (o instanceof JSONObject) {
                    JSObject notif = JSObject.fromJSONObject((JSONObject)((JSONObject)o));
                    String tag = notif.getString("tag");
                    Integer id = notif.getInteger("id");
                    if (tag == null) {
                        this.notificationManager.cancel(id.intValue());
                        continue;
                    }
                    this.notificationManager.cancel(tag, id.intValue());
                    continue;
                }
                call.reject("Expected notifications to be a list of notification objects");
            }
        }
        catch (JSONException e) {
            call.reject(e.getMessage());
        }
        call.resolve();
    }

    @PluginMethod
    public void removeAllDeliveredNotifications(PluginCall call) {
        this.notificationManager.cancelAll();
        call.resolve();
    }

    @PluginMethod
    public void createChannel(PluginCall call) {
        this.notificationChannelManager.createChannel(call);
    }

    @PluginMethod
    public void deleteChannel(PluginCall call) {
        this.notificationChannelManager.deleteChannel(call);
    }

    @PluginMethod
    public void listChannels(PluginCall call) {
        this.notificationChannelManager.listChannels(call);
    }

    @PluginMethod
    public void checkPermissions(PluginCall call) {
        if (Build.VERSION.SDK_INT < 33) {
            JSObject permissionsResultJSON = new JSObject();
            permissionsResultJSON.put(LOCAL_NOTIFICATIONS, this.getNotificationPermissionText());
            call.resolve(permissionsResultJSON);
        } else {
            super.checkPermissions(call);
        }
    }

    @PluginMethod
    public void requestPermissions(PluginCall call) {
        if (Build.VERSION.SDK_INT < 33 || this.getPermissionState(LOCAL_NOTIFICATIONS) == PermissionState.GRANTED) {
            JSObject permissionsResultJSON = new JSObject();
            permissionsResultJSON.put(LOCAL_NOTIFICATIONS, this.getNotificationPermissionText());
            call.resolve(permissionsResultJSON);
        } else {
            this.requestPermissionForAlias(LOCAL_NOTIFICATIONS, call, "permissionsCallback");
        }
    }

    @PluginMethod
    public void changeExactNotificationSetting(PluginCall call) {
        if (Build.VERSION.SDK_INT >= 31) {
            this.startActivityForResult(call, new Intent("android.settings.REQUEST_SCHEDULE_EXACT_ALARM", Uri.parse((String)("package:" + this.getActivity().getPackageName()))), "alarmPermissionsCallback");
        } else {
            this.checkExactNotificationSetting(call);
        }
    }

    @PluginMethod
    public void checkExactNotificationSetting(PluginCall call) {
        JSObject permissionsResultJSON = new JSObject();
        permissionsResultJSON.put("exact_alarm", this.getExactAlarmPermissionText());
        call.resolve(permissionsResultJSON);
    }

    @PermissionCallback
    private void permissionsCallback(PluginCall call) {
        JSObject permissionsResultJSON = new JSObject();
        permissionsResultJSON.put(LOCAL_NOTIFICATIONS, this.getNotificationPermissionText());
        call.resolve(permissionsResultJSON);
    }

    @ActivityCallback
    private void alarmPermissionsCallback(PluginCall call, ActivityResult result) {
        this.checkExactNotificationSetting(call);
    }

    private String getNotificationPermissionText() {
        if (this.manager.areNotificationsEnabled()) {
            return "granted";
        }
        return "denied";
    }

    private String getExactAlarmPermissionText() {
        if (Build.VERSION.SDK_INT >= 31) {
            AlarmManager alarmManager = (AlarmManager)this.getActivity().getSystemService("alarm");
            if (alarmManager.canScheduleExactAlarms()) {
                return "granted";
            }
            return "denied";
        }
        return "granted";
    }

    public static void fireReceived(JSObject notification) {
        LocalNotificationsPlugin localNotificationsPlugin = LocalNotificationsPlugin.getLocalNotificationsInstance();
        if (localNotificationsPlugin != null) {
            localNotificationsPlugin.notifyListeners("localNotificationReceived", notification, true);
        }
    }

    public static LocalNotificationsPlugin getLocalNotificationsInstance() {
        if (staticBridge != null && staticBridge.getWebView() != null) {
            PluginHandle handle = staticBridge.getPlugin("LocalNotifications");
            if (handle == null) {
                return null;
            }
            return (LocalNotificationsPlugin)handle.getInstance();
        }
        return null;
    }
}

