/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.localnotifications;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.capacitorjs.plugins.localnotifications.DateMatch;
import com.capacitorjs.plugins.localnotifications.LocalNotificationsPlugin;
import com.capacitorjs.plugins.localnotifications.NotificationStorage;
import com.getcapacitor.JSObject;
import com.getcapacitor.Logger;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimedNotificationPublisher
extends BroadcastReceiver {
    public static String NOTIFICATION_KEY = "NotificationPublisher.notification";
    public static String CRON_KEY = "NotificationPublisher.cron";

    public void onReceive(Context context, Intent intent) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        Notification notification = Build.VERSION.SDK_INT >= 33 ? (Notification)intent.getParcelableExtra(NOTIFICATION_KEY, Notification.class) : this.getParcelableExtraLegacy(intent, NOTIFICATION_KEY);
        notification.when = System.currentTimeMillis();
        int id = intent.getIntExtra("LocalNotificationId", Integer.MIN_VALUE);
        if (id == Integer.MIN_VALUE) {
            Logger.error((String)Logger.tags((String[])new String[]{"LN"}), (String)"No valid id supplied", null);
        }
        NotificationStorage storage = new NotificationStorage(context);
        JSObject notificationJson = storage.getSavedNotificationAsJSObject(Integer.toString(id));
        LocalNotificationsPlugin.fireReceived(notificationJson);
        notificationManager.notify(id, notification);
        if (!this.rescheduleNotificationIfNeeded(context, intent, id)) {
            storage.deleteNotification(Integer.toString(id));
        }
    }

    private Notification getParcelableExtraLegacy(Intent intent, String string) {
        return (Notification)intent.getParcelableExtra(NOTIFICATION_KEY);
    }

    private boolean rescheduleNotificationIfNeeded(Context context, Intent intent, int id) {
        String dateString = intent.getStringExtra(CRON_KEY);
        if (dateString != null) {
            DateMatch date = DateMatch.fromMatchString(dateString);
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            long trigger = date.nextTrigger(new Date());
            Intent clone = (Intent)intent.clone();
            int flags = 0x10000000;
            if (Build.VERSION.SDK_INT >= 31) {
                flags |= 0x2000000;
            }
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)id, (Intent)clone, (int)flags);
            if (Build.VERSION.SDK_INT >= 31 && !alarmManager.canScheduleExactAlarms()) {
                Logger.warn((String)"Capacitor/LocalNotification", (String)"Exact alarms not allowed in user settings.  Notification scheduled with non-exact alarm.");
                alarmManager.set(1, trigger, pendingIntent);
            } else {
                alarmManager.setExact(1, trigger, pendingIntent);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Logger.debug((String)Logger.tags((String[])new String[]{"LN"}), (String)("notification " + id + " will next fire at " + sdf.format(new Date(trigger))));
            return true;
        }
        return false;
    }
}

