/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.localnotifications;

import com.getcapacitor.JSArray;
import com.getcapacitor.JSObject;
import com.getcapacitor.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class NotificationAction {
    private String id;
    private String title;
    private Boolean input;

    public NotificationAction() {
    }

    public NotificationAction(String id, String title, Boolean input) {
        this.id = id;
        this.title = title;
        this.input = input;
    }

    public static Map<String, NotificationAction[]> buildTypes(JSArray types) {
        HashMap<String, NotificationAction[]> actionTypeMap = new HashMap<String, NotificationAction[]>();
        try {
            List objects = types.toList();
            for (JSONObject obj : objects) {
                JSObject jsObject = JSObject.fromJSONObject((JSONObject)obj);
                String actionGroupId = jsObject.getString("id");
                if (actionGroupId == null) {
                    return null;
                }
                JSONArray actions = jsObject.getJSONArray("actions");
                if (actions == null) continue;
                NotificationAction[] typesArray = new NotificationAction[actions.length()];
                for (int i = 0; i < typesArray.length; ++i) {
                    NotificationAction notificationAction = new NotificationAction();
                    JSObject action = JSObject.fromJSONObject((JSONObject)actions.getJSONObject(i));
                    notificationAction.setId(action.getString("id"));
                    notificationAction.setTitle(action.getString("title"));
                    notificationAction.setInput(action.getBool("input"));
                    typesArray[i] = notificationAction;
                }
                actionTypeMap.put(actionGroupId, typesArray);
            }
        }
        catch (Exception e) {
            Logger.error((String)Logger.tags((String[])new String[]{"LN"}), (String)"Error when building action types", (Throwable)e);
        }
        return actionTypeMap;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isInput() {
        return Boolean.TRUE.equals(this.input);
    }

    public void setInput(Boolean input) {
        this.input = input;
    }
}

