/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.localnotifications;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.UserManager;
import com.capacitorjs.plugins.localnotifications.LocalNotification;
import com.capacitorjs.plugins.localnotifications.LocalNotificationManager;
import com.capacitorjs.plugins.localnotifications.LocalNotificationSchedule;
import com.capacitorjs.plugins.localnotifications.NotificationStorage;
import com.getcapacitor.CapConfig;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LocalNotificationRestoreReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        UserManager um;
        if (!(Build.VERSION.SDK_INT < 24 || (um = (UserManager)context.getSystemService(UserManager.class)) != null && um.isUserUnlocked())) {
            return;
        }
        NotificationStorage storage = new NotificationStorage(context);
        List<String> ids = storage.getSavedNotificationIds();
        ArrayList<LocalNotification> notifications = new ArrayList<LocalNotification>(ids.size());
        ArrayList<LocalNotification> updatedNotifications = new ArrayList<LocalNotification>();
        for (String id : ids) {
            Date at;
            LocalNotification notification = storage.getSavedNotification(id);
            if (notification == null) continue;
            LocalNotificationSchedule schedule = notification.getSchedule();
            if (schedule != null && (at = schedule.getAt()) != null && at.before(new Date())) {
                long newDateTime = new Date().getTime() + 15000L;
                schedule.setAt(new Date(newDateTime));
                notification.setSchedule(schedule);
                updatedNotifications.add(notification);
            }
            notifications.add(notification);
        }
        if (updatedNotifications.size() > 0) {
            storage.appendNotifications(updatedNotifications);
        }
        CapConfig config = CapConfig.loadDefault((Context)context);
        LocalNotificationManager localNotificationManager = new LocalNotificationManager(storage, null, context, config);
        localNotificationManager.schedule(null, notifications);
    }
}

