/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.localnotifications;

import com.capacitorjs.plugins.localnotifications.DateMatch;
import com.getcapacitor.JSObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class LocalNotificationSchedule {
    public static String JS_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private Date at;
    private Boolean repeats;
    private String every;
    private Integer count;
    private DateMatch on;
    private Boolean whileIdle;
    private JSObject scheduleObj;

    public LocalNotificationSchedule(JSObject schedule) throws ParseException {
        this.scheduleObj = schedule;
        this.buildEveryElement(schedule);
        this.buildCountElement(schedule);
        this.buildAtElement(schedule);
        this.buildOnElement(schedule);
        this.whileIdle = schedule.getBoolean("allowWhileIdle", Boolean.valueOf(false));
    }

    public LocalNotificationSchedule() {
    }

    private void buildEveryElement(JSObject schedule) {
        this.every = schedule.getString("every");
    }

    private void buildCountElement(JSObject schedule) {
        this.count = schedule.getInteger("count", Integer.valueOf(1));
    }

    private void buildAtElement(JSObject schedule) throws ParseException {
        this.repeats = schedule.getBool("repeats");
        String dateString = schedule.getString("at");
        if (dateString != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(JS_DATE_FORMAT);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.at = sdf.parse(dateString);
        }
    }

    private void buildOnElement(JSObject schedule) {
        JSObject onJson = schedule.getJSObject("on");
        if (onJson != null) {
            this.on = new DateMatch();
            this.on.setYear(onJson.getInteger("year"));
            this.on.setMonth(onJson.getInteger("month"));
            this.on.setDay(onJson.getInteger("day"));
            this.on.setWeekday(onJson.getInteger("weekday"));
            this.on.setHour(onJson.getInteger("hour"));
            this.on.setMinute(onJson.getInteger("minute"));
            this.on.setSecond(onJson.getInteger("second"));
        }
    }

    public DateMatch getOn() {
        return this.on;
    }

    public JSObject getOnObj() {
        return this.scheduleObj.getJSObject("on");
    }

    public void setOn(DateMatch on) {
        this.on = on;
    }

    public Date getAt() {
        return this.at;
    }

    public void setAt(Date at) {
        this.at = at;
    }

    public Boolean getRepeats() {
        return this.repeats;
    }

    public void setRepeats(Boolean repeats) {
        this.repeats = repeats;
    }

    public String getEvery() {
        return this.every;
    }

    public void setEvery(String every) {
        this.every = every;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean allowWhileIdle() {
        return this.whileIdle;
    }

    public boolean isRepeating() {
        return Boolean.TRUE.equals(this.repeats);
    }

    public boolean isRemovable() {
        if (this.every == null && this.on == null) {
            if (this.at != null) {
                return !this.isRepeating();
            }
            return true;
        }
        return false;
    }

    public Long getEveryInterval() {
        switch (this.every) {
            case "year": {
                return (long)this.count.intValue() * 604800000L * 52L;
            }
            case "month": {
                return (long)(this.count * 30) * 86400000L;
            }
            case "two-weeks": {
                return (long)(this.count * 2) * 604800000L;
            }
            case "week": {
                return (long)this.count.intValue() * 604800000L;
            }
            case "day": {
                return (long)this.count.intValue() * 86400000L;
            }
            case "hour": {
                return (long)this.count.intValue() * 3600000L;
            }
            case "minute": {
                return (long)this.count.intValue() * 60000L;
            }
            case "second": {
                return (long)this.count.intValue() * 1000L;
            }
        }
        return null;
    }

    public Long getNextOnSchedule(Date currentTime) {
        return this.on.nextTrigger(currentTime);
    }
}

