/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.localnotifications;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.capacitorjs.plugins.localnotifications.LocalNotificationAttachment;
import com.capacitorjs.plugins.localnotifications.LocalNotificationSchedule;
import com.getcapacitor.JSArray;
import com.getcapacitor.JSObject;
import com.getcapacitor.Logger;
import com.getcapacitor.PluginCall;
import com.getcapacitor.plugin.util.AssetUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalNotification {
    private String title;
    private String body;
    private String largeBody;
    private String summaryText;
    private Integer id;
    private String sound;
    private String smallIcon;
    private String largeIcon;
    private String iconColor;
    private String actionTypeId;
    private String group;
    private List<String> inboxList;
    private boolean groupSummary;
    private boolean ongoing;
    private boolean autoCancel;
    private JSObject extra;
    private List<LocalNotificationAttachment> attachments;
    private LocalNotificationSchedule schedule;
    private String channelId;
    private String source;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setLargeBody(String largeBody) {
        this.largeBody = largeBody;
    }

    public String getLargeBody() {
        return this.largeBody;
    }

    public void setSummaryText(String summaryText) {
        this.summaryText = summaryText;
    }

    public String getSummaryText() {
        return this.summaryText;
    }

    public LocalNotificationSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(LocalNotificationSchedule schedule) {
        this.schedule = schedule;
    }

    public String getSound(Context context, int defaultSound) {
        String soundPath = null;
        int resId = 0;
        String name = AssetUtil.getResourceBaseName((String)this.sound);
        if (name != null) {
            resId = AssetUtil.getResourceID((Context)context, (String)name, (String)"raw");
        }
        if (resId == 0) {
            resId = defaultSound;
        }
        if (resId != 0) {
            soundPath = "android.resource://" + context.getPackageName() + "/" + resId;
        }
        return soundPath;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public void setSmallIcon(String smallIcon) {
        this.smallIcon = AssetUtil.getResourceBaseName((String)smallIcon);
    }

    public void setLargeIcon(String largeIcon) {
        this.largeIcon = AssetUtil.getResourceBaseName((String)largeIcon);
    }

    public void setInboxList(List<String> inboxList) {
        this.inboxList = inboxList;
    }

    public List<String> getInboxList() {
        return this.inboxList;
    }

    public String getIconColor(String globalColor) {
        if (this.iconColor != null) {
            return this.iconColor;
        }
        return globalColor;
    }

    public void setIconColor(String iconColor) {
        this.iconColor = iconColor;
    }

    public List<LocalNotificationAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<LocalNotificationAttachment> attachments) {
        this.attachments = attachments;
    }

    public String getActionTypeId() {
        return this.actionTypeId;
    }

    public void setActionTypeId(String actionTypeId) {
        this.actionTypeId = actionTypeId;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public JSObject getExtra() {
        return this.extra;
    }

    public void setExtra(JSObject extra) {
        this.extra = extra;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean isGroupSummary() {
        return this.groupSummary;
    }

    public void setGroupSummary(boolean groupSummary) {
        this.groupSummary = groupSummary;
    }

    public boolean isOngoing() {
        return this.ongoing;
    }

    public void setOngoing(boolean ongoing) {
        this.ongoing = ongoing;
    }

    public boolean isAutoCancel() {
        return this.autoCancel;
    }

    public void setAutoCancel(boolean autoCancel) {
        this.autoCancel = autoCancel;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public static List<LocalNotification> buildNotificationList(PluginCall call) {
        List notificationsJson;
        JSArray notificationArray = call.getArray("notifications");
        if (notificationArray == null) {
            call.reject("Must provide notifications array as notifications option");
            return null;
        }
        ArrayList<LocalNotification> resultLocalNotifications = new ArrayList<LocalNotification>(notificationArray.length());
        try {
            notificationsJson = notificationArray.toList();
        }
        catch (JSONException e) {
            call.reject("Provided notification format is invalid");
            return null;
        }
        for (JSONObject jsonNotification : notificationsJson) {
            JSObject notification = null;
            try {
                long identifier = jsonNotification.getLong("id");
                if (identifier > Integer.MAX_VALUE || identifier < Integer.MIN_VALUE) {
                    call.reject("The identifier should be a Java int");
                    return null;
                }
                notification = JSObject.fromJSONObject((JSONObject)jsonNotification);
            }
            catch (JSONException e) {
                call.reject("Invalid JSON object sent to NotificationPlugin", (Exception)((Object)e));
                return null;
            }
            try {
                LocalNotification activeLocalNotification = LocalNotification.buildNotificationFromJSObject(notification);
                resultLocalNotifications.add(activeLocalNotification);
            }
            catch (ParseException e) {
                call.reject("Invalid date format sent to Notification plugin", (Exception)e);
                return null;
            }
        }
        return resultLocalNotifications;
    }

    public static LocalNotification buildNotificationFromJSObject(JSObject jsonObject) throws ParseException {
        LocalNotification localNotification = new LocalNotification();
        localNotification.setSource(jsonObject.toString());
        localNotification.setId(jsonObject.getInteger("id"));
        localNotification.setBody(jsonObject.getString("body"));
        localNotification.setLargeBody(jsonObject.getString("largeBody"));
        localNotification.setSummaryText(jsonObject.getString("summaryText"));
        localNotification.setActionTypeId(jsonObject.getString("actionTypeId"));
        localNotification.setGroup(jsonObject.getString("group"));
        localNotification.setSound(jsonObject.getString("sound"));
        localNotification.setTitle(jsonObject.getString("title"));
        localNotification.setSmallIcon(jsonObject.getString("smallIcon"));
        localNotification.setLargeIcon(jsonObject.getString("largeIcon"));
        localNotification.setIconColor(jsonObject.getString("iconColor"));
        localNotification.setAttachments(LocalNotificationAttachment.getAttachments(jsonObject));
        localNotification.setGroupSummary(jsonObject.getBoolean("groupSummary", Boolean.valueOf(false)));
        localNotification.setChannelId(jsonObject.getString("channelId"));
        JSObject schedule = jsonObject.getJSObject("schedule");
        if (schedule != null) {
            localNotification.setSchedule(new LocalNotificationSchedule(schedule));
        }
        localNotification.setExtra(jsonObject.getJSObject("extra"));
        localNotification.setOngoing(jsonObject.getBoolean("ongoing", Boolean.valueOf(false)));
        localNotification.setAutoCancel(jsonObject.getBoolean("autoCancel", Boolean.valueOf(true)));
        try {
            JSONArray inboxList = jsonObject.getJSONArray("inboxList");
            if (inboxList != null) {
                ArrayList<String> inboxStringList = new ArrayList<String>();
                for (int i = 0; i < inboxList.length(); ++i) {
                    inboxStringList.add(inboxList.getString(i));
                }
                localNotification.setInboxList(inboxStringList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localNotification;
    }

    public static List<Integer> getLocalNotificationPendingList(PluginCall call) {
        List notifications = null;
        try {
            notifications = call.getArray("notifications").toList();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (notifications == null || notifications.size() == 0) {
            call.reject("Must provide notifications array as notifications option");
            return null;
        }
        ArrayList<Integer> notificationsList = new ArrayList<Integer>(notifications.size());
        for (JSONObject notificationToCancel : notifications) {
            try {
                notificationsList.add(notificationToCancel.getInt("id"));
            }
            catch (JSONException jSONException) {}
        }
        return notificationsList;
    }

    public static JSObject buildLocalNotificationPendingList(List<LocalNotification> notifications) {
        JSObject result = new JSObject();
        JSArray jsArray = new JSArray();
        for (LocalNotification notification : notifications) {
            JSObject jsNotification = new JSObject();
            jsNotification.put("id", (Object)notification.getId());
            jsNotification.put("title", notification.getTitle());
            jsNotification.put("body", notification.getBody());
            LocalNotificationSchedule schedule = notification.getSchedule();
            if (schedule != null) {
                JSObject jsSchedule = new JSObject();
                jsSchedule.put("at", (Object)schedule.getAt());
                jsSchedule.put("every", schedule.getEvery());
                jsSchedule.put("count", schedule.getCount());
                jsSchedule.put("on", (Object)schedule.getOnObj());
                jsSchedule.put("repeats", schedule.isRepeating());
                jsNotification.put("schedule", (Object)jsSchedule);
            }
            jsNotification.put("extra", (Object)notification.getExtra());
            jsArray.put((Object)jsNotification);
        }
        result.put("notifications", (Object)jsArray);
        return result;
    }

    public int getSmallIcon(Context context, int defaultIcon) {
        int resId = 0;
        if (this.smallIcon != null) {
            resId = AssetUtil.getResourceID((Context)context, (String)this.smallIcon, (String)"drawable");
        }
        if (resId == 0) {
            resId = defaultIcon;
        }
        return resId;
    }

    public Bitmap getLargeIcon(Context context) {
        if (this.largeIcon != null) {
            int resId = AssetUtil.getResourceID((Context)context, (String)this.largeIcon, (String)"drawable");
            return BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId);
        }
        return null;
    }

    public boolean isScheduled() {
        return this.schedule != null && (this.schedule.getOn() != null || this.schedule.getAt() != null || this.schedule.getEvery() != null);
    }

    public String toString() {
        return "LocalNotification{title='" + this.title + '\'' + ", body='" + this.body + '\'' + ", id=" + this.id + ", sound='" + this.sound + '\'' + ", smallIcon='" + this.smallIcon + '\'' + ", iconColor='" + this.iconColor + '\'' + ", actionTypeId='" + this.actionTypeId + '\'' + ", group='" + this.group + '\'' + ", extra=" + this.extra + ", attachments=" + this.attachments + ", schedule=" + this.schedule + ", groupSummary=" + this.groupSummary + ", ongoing=" + this.ongoing + ", autoCancel=" + this.autoCancel + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalNotification that = (LocalNotification)o;
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        if (this.largeBody != null ? !this.largeBody.equals(that.largeBody) : that.largeBody != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.sound != null ? !this.sound.equals(that.sound) : that.sound != null) {
            return false;
        }
        if (this.smallIcon != null ? !this.smallIcon.equals(that.smallIcon) : that.smallIcon != null) {
            return false;
        }
        if (this.largeIcon != null ? !this.largeIcon.equals(that.largeIcon) : that.largeIcon != null) {
            return false;
        }
        if (this.iconColor != null ? !this.iconColor.equals(that.iconColor) : that.iconColor != null) {
            return false;
        }
        if (this.actionTypeId != null ? !this.actionTypeId.equals(that.actionTypeId) : that.actionTypeId != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.extra != null ? !this.extra.equals(that.extra) : that.extra != null) {
            return false;
        }
        if (this.attachments != null ? !this.attachments.equals(that.attachments) : that.attachments != null) {
            return false;
        }
        if (this.inboxList != null ? !this.inboxList.equals(that.inboxList) : that.inboxList != null) {
            return false;
        }
        if (this.groupSummary != that.groupSummary) {
            return false;
        }
        if (this.ongoing != that.ongoing) {
            return false;
        }
        if (this.autoCancel != that.autoCancel) {
            return false;
        }
        return this.schedule != null ? this.schedule.equals(that.schedule) : that.schedule == null;
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.sound != null ? this.sound.hashCode() : 0);
        result = 31 * result + (this.smallIcon != null ? this.smallIcon.hashCode() : 0);
        result = 31 * result + (this.iconColor != null ? this.iconColor.hashCode() : 0);
        result = 31 * result + (this.actionTypeId != null ? this.actionTypeId.hashCode() : 0);
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + Boolean.hashCode(this.groupSummary);
        result = 31 * result + Boolean.hashCode(this.ongoing);
        result = 31 * result + Boolean.hashCode(this.autoCancel);
        result = 31 * result + (this.extra != null ? this.extra.hashCode() : 0);
        result = 31 * result + (this.attachments != null ? this.attachments.hashCode() : 0);
        result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
        return result;
    }

    public void setExtraFromString(String extraFromString) {
        try {
            JSONObject jsonObject = new JSONObject(extraFromString);
            this.extra = JSObject.fromJSONObject((JSONObject)jsonObject);
        }
        catch (JSONException e) {
            Logger.error((String)Logger.tags((String[])new String[]{"LN"}), (String)"Cannot rebuild extra data", (Throwable)e);
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

