/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.statusbar;

import android.view.View;
import android.view.Window;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import com.capacitorjs.plugins.statusbar.StatusBarInfo;

public class StatusBar {
    private int currentStatusBarColor;
    private final AppCompatActivity activity;
    private final String defaultStyle;

    public StatusBar(AppCompatActivity activity) {
        this.activity = activity;
        this.currentStatusBarColor = activity.getWindow().getStatusBarColor();
        this.defaultStyle = this.getStyle();
    }

    public void setStyle(String style) {
        Window window = this.activity.getWindow();
        View decorView = window.getDecorView();
        if (style.equals("DEFAULT")) {
            style = this.defaultStyle;
        }
        WindowInsetsControllerCompat windowInsetsControllerCompat = WindowCompat.getInsetsController((Window)window, (View)decorView);
        windowInsetsControllerCompat.setAppearanceLightStatusBars(!style.equals("DARK"));
    }

    public void setBackgroundColor(int color) {
        Window window = this.activity.getWindow();
        window.clearFlags(0x4000000);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(color);
        this.currentStatusBarColor = color;
    }

    public void hide() {
        View decorView = this.activity.getWindow().getDecorView();
        WindowInsetsControllerCompat windowInsetsControllerCompat = WindowCompat.getInsetsController((Window)this.activity.getWindow(), (View)decorView);
        windowInsetsControllerCompat.hide(WindowInsetsCompat.Type.statusBars());
    }

    public void show() {
        View decorView = this.activity.getWindow().getDecorView();
        WindowInsetsControllerCompat windowInsetsControllerCompat = WindowCompat.getInsetsController((Window)this.activity.getWindow(), (View)decorView);
        windowInsetsControllerCompat.show(WindowInsetsCompat.Type.statusBars());
    }

    public void setOverlaysWebView(Boolean overlays) {
        View decorView = this.activity.getWindow().getDecorView();
        int uiOptions = decorView.getSystemUiVisibility();
        if (overlays.booleanValue()) {
            uiOptions = uiOptions | 0x100 | 0x400;
            decorView.setSystemUiVisibility(uiOptions);
            this.currentStatusBarColor = this.activity.getWindow().getStatusBarColor();
            this.activity.getWindow().setStatusBarColor(0);
        } else {
            uiOptions = uiOptions & 0xFFFFFEFF & 0xFFFFFBFF;
            decorView.setSystemUiVisibility(uiOptions);
            this.activity.getWindow().setStatusBarColor(this.currentStatusBarColor);
        }
    }

    private boolean getIsOverlaid() {
        return (this.activity.getWindow().getDecorView().getSystemUiVisibility() & 0x400) == 1024;
    }

    public StatusBarInfo getInfo() {
        Window window = this.activity.getWindow();
        WindowInsetsCompat windowInsetsCompat = ViewCompat.getRootWindowInsets((View)window.getDecorView());
        boolean isVisible = windowInsetsCompat != null && windowInsetsCompat.isVisible(WindowInsetsCompat.Type.statusBars());
        StatusBarInfo info = new StatusBarInfo();
        info.setStyle(this.getStyle());
        info.setOverlays(this.getIsOverlaid());
        info.setVisible(isVisible);
        info.setColor(String.format("#%06X", 0xFFFFFF & window.getStatusBarColor()));
        return info;
    }

    private String getStyle() {
        View decorView = this.activity.getWindow().getDecorView();
        String style = "DARK";
        WindowInsetsControllerCompat windowInsetsControllerCompat = WindowCompat.getInsetsController((Window)this.activity.getWindow(), (View)decorView);
        if (windowInsetsControllerCompat.isAppearanceLightStatusBars()) {
            style = "LIGHT";
        }
        return style;
    }
}

