/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import androidx.annotation.Nullable;
import com.getcapacitor.Bridge;
import com.getcapacitor.JSArray;
import com.getcapacitor.JSObject;
import com.getcapacitor.Logger;
import com.getcapacitor.MessageHandler;
import com.getcapacitor.PluginResult;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PluginCall {
    public static final String CALLBACK_ID_DANGLING = "-1";
    private final MessageHandler msgHandler;
    private final String pluginId;
    private final String callbackId;
    private final String methodName;
    private final JSObject data;
    private boolean keepAlive = false;
    @Deprecated
    private boolean isReleased = false;

    public PluginCall(MessageHandler msgHandler, String pluginId, String callbackId, String methodName, JSObject data) {
        this.msgHandler = msgHandler;
        this.pluginId = pluginId;
        this.callbackId = callbackId;
        this.methodName = methodName;
        this.data = data;
    }

    public void successCallback(PluginResult successResult) {
        if (CALLBACK_ID_DANGLING.equals(this.callbackId)) {
            return;
        }
        this.msgHandler.sendResponseMessage(this, successResult, null);
    }

    @Deprecated
    public void success(JSObject data) {
        PluginResult result = new PluginResult(data);
        this.msgHandler.sendResponseMessage(this, result, null);
    }

    @Deprecated
    public void success() {
        this.resolve(new JSObject());
    }

    public void resolve(JSObject data) {
        PluginResult result = new PluginResult(data);
        this.msgHandler.sendResponseMessage(this, result, null);
    }

    public void resolve() {
        this.msgHandler.sendResponseMessage(this, null, null);
    }

    public void errorCallback(String msg) {
        PluginResult errorResult = new PluginResult();
        try {
            errorResult.put("message", msg);
        }
        catch (Exception jsonEx) {
            Logger.error(Logger.tags("Plugin"), jsonEx.toString(), null);
        }
        this.msgHandler.sendResponseMessage(this, null, errorResult);
    }

    @Deprecated
    public void error(String msg, Exception ex) {
        this.reject(msg, ex);
    }

    @Deprecated
    public void error(String msg, String code, Exception ex) {
        this.reject(msg, code, ex);
    }

    @Deprecated
    public void error(String msg) {
        this.reject(msg);
    }

    public void reject(String msg, String code, Exception ex, JSObject data) {
        PluginResult errorResult = new PluginResult();
        if (ex != null) {
            Logger.error(Logger.tags("Plugin"), msg, ex);
        }
        try {
            errorResult.put("message", msg);
            errorResult.put("code", code);
            if (null != data) {
                errorResult.put("data", (Object)data);
            }
        }
        catch (Exception jsonEx) {
            Logger.error(Logger.tags("Plugin"), jsonEx.getMessage(), jsonEx);
        }
        this.msgHandler.sendResponseMessage(this, null, errorResult);
    }

    public void reject(String msg, Exception ex, JSObject data) {
        this.reject(msg, null, ex, data);
    }

    public void reject(String msg, String code, JSObject data) {
        this.reject(msg, code, null, data);
    }

    public void reject(String msg, String code, Exception ex) {
        this.reject(msg, code, ex, null);
    }

    public void reject(String msg, JSObject data) {
        this.reject(msg, null, null, data);
    }

    public void reject(String msg, Exception ex) {
        this.reject(msg, null, ex, null);
    }

    public void reject(String msg, String code) {
        this.reject(msg, code, null, null);
    }

    public void reject(String msg) {
        this.reject(msg, null, null, null);
    }

    public void unimplemented() {
        this.unimplemented("not implemented");
    }

    public void unimplemented(String msg) {
        this.reject(msg, "UNIMPLEMENTED", null, null);
    }

    public void unavailable() {
        this.unavailable("not available");
    }

    public void unavailable(String msg) {
        this.reject(msg, "UNAVAILABLE", null, null);
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public JSObject getData() {
        return this.data;
    }

    @Nullable
    public String getString(String name) {
        return this.getString(name, null);
    }

    @Nullable
    public String getString(String name, @Nullable String defaultValue) {
        Object value = this.data.opt(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    @Nullable
    public Integer getInt(String name) {
        return this.getInt(name, null);
    }

    @Nullable
    public Integer getInt(String name, @Nullable Integer defaultValue) {
        Object value = this.data.opt(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return defaultValue;
    }

    @Nullable
    public Long getLong(String name) {
        return this.getLong(name, null);
    }

    @Nullable
    public Long getLong(String name, @Nullable Long defaultValue) {
        Object value = this.data.opt(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return defaultValue;
    }

    @Nullable
    public Float getFloat(String name) {
        return this.getFloat(name, null);
    }

    @Nullable
    public Float getFloat(String name, @Nullable Float defaultValue) {
        Object value = this.data.opt(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Double) {
            return Float.valueOf(((Double)value).floatValue());
        }
        if (value instanceof Integer) {
            return Float.valueOf(((Integer)value).floatValue());
        }
        return defaultValue;
    }

    @Nullable
    public Double getDouble(String name) {
        return this.getDouble(name, null);
    }

    @Nullable
    public Double getDouble(String name, @Nullable Double defaultValue) {
        Object value = this.data.opt(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        return defaultValue;
    }

    @Nullable
    public Boolean getBoolean(String name) {
        return this.getBoolean(name, null);
    }

    @Nullable
    public Boolean getBoolean(String name, @Nullable Boolean defaultValue) {
        Object value = this.data.opt(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public JSObject getObject(String name) {
        return this.getObject(name, null);
    }

    @Nullable
    public JSObject getObject(String name, JSObject defaultValue) {
        Object value = this.data.opt(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof JSONObject) {
            try {
                return JSObject.fromJSONObject((JSONObject)value);
            }
            catch (JSONException ex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public JSArray getArray(String name) {
        return this.getArray(name, null);
    }

    @Nullable
    public JSArray getArray(String name, JSArray defaultValue) {
        Object value = this.data.opt(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof JSONArray) {
            try {
                JSONArray valueArray = (JSONArray)value;
                ArrayList<Object> items = new ArrayList<Object>();
                for (int i = 0; i < valueArray.length(); ++i) {
                    items.add(valueArray.get(i));
                }
                return new JSArray(items.toArray());
            }
            catch (JSONException ex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    @Deprecated
    public boolean hasOption(String name) {
        return this.data.has(name);
    }

    @Deprecated
    public void save() {
        this.setKeepAlive(true);
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void release(Bridge bridge) {
        this.keepAlive = false;
        bridge.releaseCall(this);
        this.isReleased = true;
    }

    @Deprecated
    public boolean isSaved() {
        return this.isKeptAlive();
    }

    public boolean isKeptAlive() {
        return this.keepAlive;
    }

    @Deprecated
    public boolean isReleased() {
        return this.isReleased;
    }

    class PluginCallDataTypeException
    extends Exception {
        PluginCallDataTypeException(String m) {
            super(m);
        }
    }
}

