/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebViewClient;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.pm.PackageInfoCompat;
import androidx.fragment.app.Fragment;
import androidx.webkit.WebViewCompat;
import androidx.webkit.WebViewFeature;
import com.getcapacitor.App;
import com.getcapacitor.BridgeWebChromeClient;
import com.getcapacitor.BridgeWebViewClient;
import com.getcapacitor.CapConfig;
import com.getcapacitor.CapacitorWebView;
import com.getcapacitor.InvalidPluginException;
import com.getcapacitor.InvalidPluginMethodException;
import com.getcapacitor.JSExport;
import com.getcapacitor.JSInjector;
import com.getcapacitor.JSObject;
import com.getcapacitor.Logger;
import com.getcapacitor.MessageHandler;
import com.getcapacitor.NativePlugin;
import com.getcapacitor.PermissionState;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginHandle;
import com.getcapacitor.PluginLoadException;
import com.getcapacitor.RouteProcessor;
import com.getcapacitor.ServerPath;
import com.getcapacitor.WebViewListener;
import com.getcapacitor.WebViewLocalServer;
import com.getcapacitor.android.R;
import com.getcapacitor.annotation.CapacitorPlugin;
import com.getcapacitor.annotation.Permission;
import com.getcapacitor.cordova.MockCordovaInterfaceImpl;
import com.getcapacitor.cordova.MockCordovaWebViewImpl;
import com.getcapacitor.plugin.CapacitorCookies;
import com.getcapacitor.plugin.CapacitorHttp;
import com.getcapacitor.plugin.WebView;
import com.getcapacitor.util.HostMask;
import com.getcapacitor.util.InternalUtils;
import com.getcapacitor.util.PermissionHelper;
import com.getcapacitor.util.WebColor;
import java.io.File;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cordova.ConfigXmlParser;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.PluginManager;
import org.json.JSONException;

public class Bridge {
    private static final String PREFS_NAME = "CapacitorSettings";
    private static final String PERMISSION_PREFS_NAME = "PluginPermStates";
    private static final String BUNDLE_LAST_PLUGIN_ID_KEY = "capacitorLastActivityPluginId";
    private static final String BUNDLE_LAST_PLUGIN_CALL_METHOD_NAME_KEY = "capacitorLastActivityPluginMethod";
    private static final String BUNDLE_PLUGIN_CALL_OPTIONS_SAVED_KEY = "capacitorLastPluginCallOptions";
    private static final String BUNDLE_PLUGIN_CALL_BUNDLE_KEY = "capacitorLastPluginCallBundle";
    private static final String LAST_BINARY_VERSION_CODE = "lastBinaryVersionCode";
    private static final String LAST_BINARY_VERSION_NAME = "lastBinaryVersionName";
    private static final String MINIMUM_ANDROID_WEBVIEW_ERROR = "System WebView is not supported";
    public static final String DEFAULT_WEB_ASSET_DIR = "public";
    public static final String CAPACITOR_HTTP_SCHEME = "http";
    public static final String CAPACITOR_HTTPS_SCHEME = "https";
    public static final String CAPACITOR_FILE_START = "/_capacitor_file_";
    public static final String CAPACITOR_CONTENT_START = "/_capacitor_content_";
    public static final String CAPACITOR_HTTP_INTERCEPTOR_START = "/_capacitor_http_interceptor_";
    @Deprecated
    public static final String CAPACITOR_HTTPS_INTERCEPTOR_START = "/_capacitor_https_interceptor_";
    public static final String CAPACITOR_HTTP_INTERCEPTOR_URL_PARAM = "u";
    public static final int DEFAULT_ANDROID_WEBVIEW_VERSION = 60;
    public static final int MINIMUM_ANDROID_WEBVIEW_VERSION = 55;
    public static final int DEFAULT_HUAWEI_WEBVIEW_VERSION = 10;
    public static final int MINIMUM_HUAWEI_WEBVIEW_VERSION = 10;
    private CapConfig config;
    private final AppCompatActivity context;
    private final Fragment fragment;
    private WebViewLocalServer localServer;
    private String localUrl;
    private String appUrl;
    private String appUrlConfig;
    private HostMask appAllowNavigationMask;
    private Set<String> allowedOriginRules = new HashSet<String>();
    private ArrayList<String> authorities = new ArrayList();
    private final android.webkit.WebView webView;
    public final MockCordovaInterfaceImpl cordovaInterface;
    private CordovaWebView cordovaWebView;
    private CordovaPreferences preferences;
    private BridgeWebViewClient webViewClient;
    private App app;
    private final MessageHandler msgHandler;
    private final HandlerThread handlerThread = new HandlerThread("CapacitorPlugins");
    private Handler taskHandler = null;
    private final List<Class<? extends Plugin>> initialPlugins;
    private final List<Plugin> pluginInstances;
    private Map<String, PluginHandle> plugins = new HashMap<String, PluginHandle>();
    private Map<String, PluginCall> savedCalls = new HashMap<String, PluginCall>();
    private Map<String, LinkedList<String>> savedPermissionCallIds = new HashMap<String, LinkedList<String>>();
    private PluginCall pluginCallForLastActivity;
    private Uri intentUri;
    private List<WebViewListener> webViewListeners = new ArrayList<WebViewListener>();
    private RouteProcessor routeProcessor;
    private ServerPath serverPath;

    @Deprecated
    public Bridge(AppCompatActivity context, android.webkit.WebView webView, List<Class<? extends Plugin>> initialPlugins, MockCordovaInterfaceImpl cordovaInterface, PluginManager pluginManager, CordovaPreferences preferences, CapConfig config) {
        this(context, null, null, webView, initialPlugins, new ArrayList<Plugin>(), cordovaInterface, pluginManager, preferences, config);
    }

    private Bridge(AppCompatActivity context, ServerPath serverPath, Fragment fragment, android.webkit.WebView webView, List<Class<? extends Plugin>> initialPlugins, List<Plugin> pluginInstances, MockCordovaInterfaceImpl cordovaInterface, PluginManager pluginManager, CordovaPreferences preferences, CapConfig config) {
        this.app = new App();
        this.serverPath = serverPath;
        this.context = context;
        this.fragment = fragment;
        this.webView = webView;
        this.webViewClient = new BridgeWebViewClient(this);
        this.initialPlugins = initialPlugins;
        this.pluginInstances = pluginInstances;
        this.cordovaInterface = cordovaInterface;
        this.preferences = preferences;
        this.handlerThread.start();
        this.taskHandler = new Handler(this.handlerThread.getLooper());
        this.config = config != null ? config : CapConfig.loadDefault((Context)this.getActivity());
        Logger.init(this.config);
        this.initWebView();
        this.setAllowedOriginRules();
        this.msgHandler = new MessageHandler(this, webView, pluginManager);
        Intent intent = context.getIntent();
        this.intentUri = intent.getData();
        this.registerAllPlugins();
        this.loadWebView();
    }

    private void setAllowedOriginRules() {
        String[] appAllowNavigationConfig = this.config.getAllowNavigation();
        String authority = this.getHost();
        String scheme = this.getScheme();
        this.allowedOriginRules.add(scheme + "://" + authority);
        if (this.getServerUrl() != null) {
            this.allowedOriginRules.add(this.getServerUrl());
        }
        if (appAllowNavigationConfig != null) {
            for (String allowNavigation : appAllowNavigationConfig) {
                if (!allowNavigation.startsWith(CAPACITOR_HTTP_SCHEME)) {
                    this.allowedOriginRules.add("https://" + allowNavigation);
                    continue;
                }
                this.allowedOriginRules.add(allowNavigation);
            }
            this.authorities.addAll(Arrays.asList(appAllowNavigationConfig));
        }
        this.appAllowNavigationMask = HostMask.Parser.parse(appAllowNavigationConfig);
    }

    public App getApp() {
        return this.app;
    }

    private void loadWebView() {
        SharedPreferences prefs;
        String path;
        boolean html5mode = this.config.isHTML5Mode();
        JSInjector injector = this.getJSInjector();
        if (WebViewFeature.isFeatureSupported((String)"DOCUMENT_START_SCRIPT")) {
            String allowedOrigin = Uri.parse((String)this.appUrl).buildUpon().path(null).fragment(null).clearQuery().build().toString();
            try {
                WebViewCompat.addDocumentStartJavaScript((android.webkit.WebView)this.webView, (String)injector.getScriptString(), Collections.singleton(allowedOrigin));
                injector = null;
            }
            catch (IllegalArgumentException ex) {
                Logger.warn("Invalid url, using fallback");
            }
        }
        this.localServer = new WebViewLocalServer((Context)this.context, this, injector, this.authorities, html5mode);
        this.localServer.hostAssets(DEFAULT_WEB_ASSET_DIR);
        Logger.debug("Loading app at " + this.appUrl);
        this.webView.setWebChromeClient((WebChromeClient)new BridgeWebChromeClient(this));
        this.webView.setWebViewClient((WebViewClient)this.webViewClient);
        if (!this.isDeployDisabled() && !this.isNewBinary() && (path = (prefs = this.getContext().getSharedPreferences("CapWebViewSettings", 0)).getString("serverBasePath", null)) != null && !path.isEmpty() && new File(path).exists()) {
            this.setServerBasePath(path);
        }
        if (!this.isMinimumWebViewInstalled()) {
            String errorUrl = this.getErrorUrl();
            if (errorUrl != null) {
                this.webView.loadUrl(errorUrl);
                return;
            }
            Logger.error(MINIMUM_ANDROID_WEBVIEW_ERROR);
        }
        if (this.serverPath != null) {
            if (this.serverPath.getType() == ServerPath.PathType.ASSET_PATH) {
                this.setServerAssetPath(this.serverPath.getPath());
            } else {
                this.setServerBasePath(this.serverPath.getPath());
            }
        } else {
            this.webView.loadUrl(this.appUrl);
        }
    }

    @SuppressLint(value={"WebViewApiAvailability"})
    public boolean isMinimumWebViewInstalled() {
        PackageManager pm = this.getContext().getPackageManager();
        if (Build.VERSION.SDK_INT >= 26) {
            PackageInfo info = android.webkit.WebView.getCurrentWebViewPackage();
            Pattern pattern = Pattern.compile("(\\d+)");
            Matcher matcher = pattern.matcher(info.versionName);
            if (matcher.find()) {
                String majorVersionStr = matcher.group(0);
                int majorVersion = Integer.parseInt(majorVersionStr);
                if (info.packageName.equals("com.huawei.webview")) {
                    return majorVersion >= this.config.getMinHuaweiWebViewVersion();
                }
                return majorVersion >= this.config.getMinWebViewVersion();
            }
            return false;
        }
        try {
            String webViewPackage = "com.google.android.webview";
            if (Build.VERSION.SDK_INT >= 24) {
                webViewPackage = "com.android.chrome";
            }
            PackageInfo info = InternalUtils.getPackageInfo(pm, webViewPackage);
            String majorVersionStr = info.versionName.split("\\.")[0];
            int majorVersion = Integer.parseInt(majorVersionStr);
            return majorVersion >= this.config.getMinWebViewVersion();
        }
        catch (Exception ex) {
            Logger.warn("Unable to get package info for 'com.google.android.webview'" + ex.toString());
            try {
                PackageInfo info = InternalUtils.getPackageInfo(pm, "com.android.webview");
                String majorVersionStr = info.versionName.split("\\.")[0];
                int majorVersion = Integer.parseInt(majorVersionStr);
                return majorVersion >= this.config.getMinWebViewVersion();
            }
            catch (Exception ex2) {
                Logger.warn("Unable to get package info for 'com.android.webview'" + ex2.toString());
                int amazonFireMajorWebViewVersion = this.extractWebViewMajorVersion(pm, "com.amazon.webview.chromium");
                return amazonFireMajorWebViewVersion >= this.config.getMinWebViewVersion();
            }
        }
    }

    private int extractWebViewMajorVersion(PackageManager pm, String webViewPackageName) {
        try {
            PackageInfo info = InternalUtils.getPackageInfo(pm, webViewPackageName);
            String majorVersionStr = info.versionName.split("\\.")[0];
            int majorVersion = Integer.parseInt(majorVersionStr);
            return majorVersion;
        }
        catch (Exception ex) {
            Logger.warn(String.format("Unable to get package info for '%s' with err '%s'", webViewPackageName, ex));
            return 0;
        }
    }

    public boolean launchIntent(Uri url) {
        for (Map.Entry<String, PluginHandle> entry : this.plugins.entrySet()) {
            Boolean shouldOverrideLoad;
            Plugin plugin = entry.getValue().getInstance();
            if (plugin == null || (shouldOverrideLoad = plugin.shouldOverrideLoad(url)) == null) continue;
            return shouldOverrideLoad;
        }
        if (url.getScheme().equals("data") || url.getScheme().equals("blob")) {
            return false;
        }
        Uri appUri = Uri.parse((String)this.appUrl);
        if (!(appUri.getHost().equals(url.getHost()) && url.getScheme().equals(appUri.getScheme()) || this.appAllowNavigationMask.matches(url.getHost()))) {
            try {
                Intent openIntent = new Intent("android.intent.action.VIEW", url);
                this.getContext().startActivity(openIntent);
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private boolean isNewBinary() {
        String versionCode = "";
        String versionName = "";
        SharedPreferences prefs = this.getContext().getSharedPreferences("CapWebViewSettings", 0);
        String lastVersionCode = prefs.getString(LAST_BINARY_VERSION_CODE, null);
        String lastVersionName = prefs.getString(LAST_BINARY_VERSION_NAME, null);
        try {
            PackageManager pm = this.getContext().getPackageManager();
            PackageInfo pInfo = InternalUtils.getPackageInfo(pm, this.getContext().getPackageName());
            versionCode = Integer.toString((int)PackageInfoCompat.getLongVersionCode((PackageInfo)pInfo));
            versionName = pInfo.versionName;
        }
        catch (Exception ex) {
            Logger.error("Unable to get package info", ex);
        }
        if (!versionCode.equals(lastVersionCode) || !versionName.equals(lastVersionName)) {
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(LAST_BINARY_VERSION_CODE, versionCode);
            editor.putString(LAST_BINARY_VERSION_NAME, versionName);
            editor.putString("serverBasePath", "");
            editor.apply();
            return true;
        }
        return false;
    }

    public boolean isDeployDisabled() {
        return this.preferences.getBoolean("DisableDeploy", false);
    }

    public boolean shouldKeepRunning() {
        return this.preferences.getBoolean("KeepRunning", true);
    }

    public void handleAppUrlLoadError(Exception ex) {
        if (ex instanceof SocketTimeoutException) {
            Logger.error("Unable to load app. Ensure the server is running at " + this.appUrl + ", or modify the appUrl setting in capacitor.config.json (make sure to npx cap copy after to commit changes).", ex);
        }
    }

    public boolean isDevMode() {
        return (this.getActivity().getApplicationInfo().flags & 2) != 0;
    }

    protected void setCordovaWebView(CordovaWebView cordovaWebView) {
        this.cordovaWebView = cordovaWebView;
    }

    public Context getContext() {
        return this.context;
    }

    public AppCompatActivity getActivity() {
        return this.context;
    }

    public Fragment getFragment() {
        return this.fragment;
    }

    public android.webkit.WebView getWebView() {
        return this.webView;
    }

    public Uri getIntentUri() {
        return this.intentUri;
    }

    public String getScheme() {
        return this.config.getAndroidScheme();
    }

    public String getHost() {
        return this.config.getHostname();
    }

    public String getServerUrl() {
        return this.config.getServerUrl();
    }

    public String getErrorUrl() {
        String errorPath = this.config.getErrorPath();
        if (errorPath != null && !errorPath.trim().isEmpty()) {
            String authority = this.getHost();
            String scheme = this.getScheme();
            String localUrl = scheme + "://" + authority;
            return localUrl + "/" + errorPath;
        }
        return null;
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public CapConfig getConfig() {
        return this.config;
    }

    public void reset() {
        this.savedCalls = new HashMap<String, PluginCall>();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebView() {
        String overrideUserAgent;
        String appendUserAgent;
        WebSettings settings = this.webView.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setDomStorageEnabled(true);
        settings.setGeolocationEnabled(true);
        settings.setDatabaseEnabled(true);
        settings.setMediaPlaybackRequiresUserGesture(false);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (this.config.isMixedContentAllowed()) {
            settings.setMixedContentMode(0);
        }
        if ((appendUserAgent = this.config.getAppendedUserAgentString()) != null) {
            String defaultUserAgent = settings.getUserAgentString();
            settings.setUserAgentString(defaultUserAgent + " " + appendUserAgent);
        }
        if ((overrideUserAgent = this.config.getOverriddenUserAgentString()) != null) {
            settings.setUserAgentString(overrideUserAgent);
        }
        String backgroundColor = this.config.getBackgroundColor();
        try {
            if (backgroundColor != null) {
                this.webView.setBackgroundColor(WebColor.parseColor(backgroundColor));
            }
        }
        catch (IllegalArgumentException ex) {
            Logger.debug("WebView background color not applied");
        }
        settings.setDisplayZoomControls(false);
        settings.setBuiltInZoomControls(this.config.isZoomableWebView());
        if (this.config.isInitialFocus()) {
            this.webView.requestFocusFromTouch();
        }
        android.webkit.WebView.setWebContentsDebuggingEnabled((boolean)this.config.isWebContentsDebuggingEnabled());
        this.appUrlConfig = this.getServerUrl();
        String authority = this.getHost();
        this.authorities.add(authority);
        String scheme = this.getScheme();
        this.localUrl = scheme + "://" + authority;
        if (this.appUrlConfig != null) {
            try {
                URL appUrlObject = new URL(this.appUrlConfig);
                this.authorities.add(appUrlObject.getAuthority());
            }
            catch (Exception ex) {
                Logger.error("Provided server url is invalid: " + ex.getMessage());
                return;
            }
            this.localUrl = this.appUrlConfig;
            this.appUrl = this.appUrlConfig;
        } else {
            this.appUrl = this.localUrl;
            if (!scheme.equals(CAPACITOR_HTTP_SCHEME) && !scheme.equals(CAPACITOR_HTTPS_SCHEME)) {
                this.appUrl = this.appUrl + "/";
            }
        }
        String appUrlPath = this.config.getStartPath();
        if (appUrlPath != null && !appUrlPath.trim().isEmpty()) {
            this.appUrl = this.appUrl + appUrlPath;
        }
    }

    private void registerAllPlugins() {
        this.registerPlugin(CapacitorCookies.class);
        this.registerPlugin(WebView.class);
        this.registerPlugin(CapacitorHttp.class);
        for (Class<? extends Plugin> pluginClass : this.initialPlugins) {
            this.registerPlugin(pluginClass);
        }
        for (Plugin plugin : this.pluginInstances) {
            this.registerPluginInstance(plugin);
        }
    }

    public void registerPlugins(Class<? extends Plugin>[] pluginClasses) {
        for (Class<? extends Plugin> plugin : pluginClasses) {
            this.registerPlugin(plugin);
        }
    }

    public void registerPluginInstances(Plugin[] pluginInstances) {
        for (Plugin plugin : pluginInstances) {
            this.registerPluginInstance(plugin);
        }
    }

    private String getLegacyPluginName(Class<? extends Plugin> pluginClass) {
        NativePlugin legacyPluginAnnotation = pluginClass.getAnnotation(NativePlugin.class);
        if (legacyPluginAnnotation == null) {
            Logger.error("Plugin doesn't have the @CapacitorPlugin annotation. Please add it");
            return null;
        }
        return legacyPluginAnnotation.name();
    }

    public void registerPlugin(Class<? extends Plugin> pluginClass) {
        String pluginId = this.pluginId(pluginClass);
        if (pluginId == null) {
            return;
        }
        try {
            this.plugins.put(pluginId, new PluginHandle(this, pluginClass));
        }
        catch (InvalidPluginException ex) {
            this.logInvalidPluginException(pluginClass);
        }
        catch (PluginLoadException ex) {
            this.logPluginLoadException(pluginClass, ex);
        }
    }

    public void registerPluginInstance(Plugin plugin) {
        Class<?> clazz = plugin.getClass();
        String pluginId = this.pluginId(clazz);
        if (pluginId == null) {
            return;
        }
        try {
            this.plugins.put(pluginId, new PluginHandle(this, plugin));
        }
        catch (InvalidPluginException ex) {
            this.logInvalidPluginException(clazz);
        }
    }

    private String pluginId(Class<? extends Plugin> clazz) {
        String pluginName = this.pluginName(clazz);
        String pluginId = clazz.getSimpleName();
        if (pluginName == null) {
            return null;
        }
        if (!pluginName.equals("")) {
            pluginId = pluginName;
        }
        Logger.debug("Registering plugin instance: " + pluginId);
        return pluginId;
    }

    private String pluginName(Class<? extends Plugin> clazz) {
        CapacitorPlugin pluginAnnotation = clazz.getAnnotation(CapacitorPlugin.class);
        String pluginName = pluginAnnotation == null ? this.getLegacyPluginName(clazz) : pluginAnnotation.name();
        return pluginName;
    }

    private void logInvalidPluginException(Class<? extends Plugin> clazz) {
        Logger.error("NativePlugin " + clazz.getName() + " is invalid. Ensure the @CapacitorPlugin annotation exists on the plugin class and the class extends Plugin");
    }

    private void logPluginLoadException(Class<? extends Plugin> clazz, Exception ex) {
        Logger.error("NativePlugin " + clazz.getName() + " failed to load", ex);
    }

    public PluginHandle getPlugin(String pluginId) {
        return this.plugins.get(pluginId);
    }

    @Deprecated
    public PluginHandle getPluginWithRequestCode(int requestCode) {
        for (PluginHandle handle : this.plugins.values()) {
            int[] requestCodes;
            CapacitorPlugin pluginAnnotation = handle.getPluginAnnotation();
            if (pluginAnnotation == null) {
                NativePlugin legacyPluginAnnotation = handle.getLegacyPluginAnnotation();
                if (legacyPluginAnnotation == null) continue;
                if (legacyPluginAnnotation.permissionRequestCode() == requestCode) {
                    return handle;
                }
                int[] nArray = requestCodes = legacyPluginAnnotation.requestCodes();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int rc = nArray[i];
                    if (rc != requestCode) continue;
                    return handle;
                }
                continue;
            }
            for (int rc : requestCodes = pluginAnnotation.requestCodes()) {
                if (rc != requestCode) continue;
                return handle;
            }
        }
        return null;
    }

    public void callPluginMethod(String pluginId, String methodName, PluginCall call) {
        try {
            PluginHandle plugin = this.getPlugin(pluginId);
            if (plugin == null) {
                Logger.error("unable to find plugin : " + pluginId);
                call.errorCallback("unable to find plugin : " + pluginId);
                return;
            }
            if (Logger.shouldLog()) {
                Logger.verbose("callback: " + call.getCallbackId() + ", pluginId: " + plugin.getId() + ", methodName: " + methodName + ", methodData: " + call.getData().toString());
            }
            Runnable currentThreadTask = () -> {
                try {
                    plugin.invoke(methodName, call);
                    if (call.isKeptAlive()) {
                        this.saveCall(call);
                    }
                }
                catch (InvalidPluginMethodException | PluginLoadException ex) {
                    Logger.error("Unable to execute plugin method", ex);
                }
                catch (Exception ex) {
                    Logger.error("Serious error executing plugin", ex);
                    throw new RuntimeException(ex);
                }
            };
            this.taskHandler.post(currentThreadTask);
        }
        catch (Exception ex) {
            Logger.error(Logger.tags("callPluginMethod"), "error : " + ex, null);
            call.errorCallback(ex.toString());
        }
    }

    public void eval(String js, ValueCallback<String> callback) {
        Handler mainHandler = new Handler(this.context.getMainLooper());
        mainHandler.post(() -> this.webView.evaluateJavascript(js, callback));
    }

    public void logToJs(String message, String level) {
        this.eval("window.Capacitor.logJs(\"" + message + "\", \"" + level + "\")", null);
    }

    public void logToJs(String message) {
        this.logToJs(message, "log");
    }

    public void triggerJSEvent(String eventName, String target) {
        this.eval("window.Capacitor.triggerEvent(\"" + eventName + "\", \"" + target + "\")", (ValueCallback<String>)((ValueCallback)s -> {}));
    }

    public void triggerJSEvent(String eventName, String target, String data) {
        this.eval("window.Capacitor.triggerEvent(\"" + eventName + "\", \"" + target + "\", " + data + ")", (ValueCallback<String>)((ValueCallback)s -> {}));
    }

    public void triggerWindowJSEvent(String eventName) {
        this.triggerJSEvent(eventName, "window");
    }

    public void triggerWindowJSEvent(String eventName, String data) {
        this.triggerJSEvent(eventName, "window", data);
    }

    public void triggerDocumentJSEvent(String eventName) {
        this.triggerJSEvent(eventName, "document");
    }

    public void triggerDocumentJSEvent(String eventName, String data) {
        this.triggerJSEvent(eventName, "document", data);
    }

    public void execute(Runnable runnable) {
        this.taskHandler.post(runnable);
    }

    public void executeOnMainThread(Runnable runnable) {
        Handler mainHandler = new Handler(this.context.getMainLooper());
        mainHandler.post(runnable);
    }

    public void saveCall(PluginCall call) {
        this.savedCalls.put(call.getCallbackId(), call);
    }

    public PluginCall getSavedCall(String callbackId) {
        if (callbackId == null) {
            return null;
        }
        return this.savedCalls.get(callbackId);
    }

    PluginCall getPluginCallForLastActivity() {
        PluginCall pluginCallForLastActivity = this.pluginCallForLastActivity;
        this.pluginCallForLastActivity = null;
        return pluginCallForLastActivity;
    }

    void setPluginCallForLastActivity(PluginCall pluginCallForLastActivity) {
        this.pluginCallForLastActivity = pluginCallForLastActivity;
    }

    public void releaseCall(PluginCall call) {
        this.releaseCall(call.getCallbackId());
    }

    public void releaseCall(String callbackId) {
        this.savedCalls.remove(callbackId);
    }

    protected PluginCall getPermissionCall(String pluginId) {
        LinkedList<String> permissionCallIds = this.savedPermissionCallIds.get(pluginId);
        String savedCallId = null;
        if (permissionCallIds != null) {
            savedCallId = permissionCallIds.poll();
        }
        return this.getSavedCall(savedCallId);
    }

    protected void savePermissionCall(PluginCall call) {
        if (call != null) {
            if (!this.savedPermissionCallIds.containsKey(call.getPluginId())) {
                this.savedPermissionCallIds.put(call.getPluginId(), new LinkedList());
            }
            this.savedPermissionCallIds.get(call.getPluginId()).add(call.getCallbackId());
            this.saveCall(call);
        }
    }

    public <I, O> ActivityResultLauncher<I> registerForActivityResult(@NonNull ActivityResultContract<I, O> contract, @NonNull ActivityResultCallback<O> callback) {
        if (this.fragment != null) {
            return this.fragment.registerForActivityResult(contract, callback);
        }
        return this.context.registerForActivityResult(contract, callback);
    }

    private JSInjector getJSInjector() {
        try {
            String globalJS = JSExport.getGlobalJS((Context)this.context, this.config.isLoggingEnabled(), this.isDevMode());
            String bridgeJS = JSExport.getBridgeJS((Context)this.context);
            String pluginJS = JSExport.getPluginJS(this.plugins.values());
            String cordovaJS = JSExport.getCordovaJS((Context)this.context);
            String cordovaPluginsJS = JSExport.getCordovaPluginJS((Context)this.context);
            String cordovaPluginsFileJS = JSExport.getCordovaPluginsFileJS((Context)this.context);
            String localUrlJS = "window.WEBVIEW_SERVER_URL = '" + this.localUrl + "';";
            return new JSInjector(globalJS, bridgeJS, pluginJS, cordovaJS, cordovaPluginsJS, cordovaPluginsFileJS, localUrlJS);
        }
        catch (Exception ex) {
            Logger.error("Unable to export Capacitor JS. App will not function!", ex);
            return null;
        }
    }

    public void restoreInstanceState(Bundle savedInstanceState) {
        String lastPluginId = savedInstanceState.getString(BUNDLE_LAST_PLUGIN_ID_KEY);
        String lastPluginCallMethod = savedInstanceState.getString(BUNDLE_LAST_PLUGIN_CALL_METHOD_NAME_KEY);
        String lastOptionsJson = savedInstanceState.getString(BUNDLE_PLUGIN_CALL_OPTIONS_SAVED_KEY);
        if (lastPluginId != null) {
            if (lastOptionsJson != null) {
                try {
                    JSObject options = new JSObject(lastOptionsJson);
                    this.pluginCallForLastActivity = new PluginCall(this.msgHandler, lastPluginId, "-1", lastPluginCallMethod, options);
                }
                catch (JSONException ex) {
                    Logger.error("Unable to restore plugin call, unable to parse persisted JSON object", ex);
                }
            }
            Bundle bundleData = savedInstanceState.getBundle(BUNDLE_PLUGIN_CALL_BUNDLE_KEY);
            PluginHandle lastPlugin = this.getPlugin(lastPluginId);
            if (bundleData != null && lastPlugin != null) {
                lastPlugin.getInstance().restoreState(bundleData);
            } else {
                Logger.error("Unable to restore last plugin call");
            }
        }
    }

    public void saveInstanceState(Bundle outState) {
        PluginCall call;
        PluginHandle handle;
        Logger.debug("Saving instance state!");
        if (this.pluginCallForLastActivity != null && (handle = this.getPlugin((call = this.pluginCallForLastActivity).getPluginId())) != null) {
            Bundle bundle = handle.getInstance().saveInstanceState();
            if (bundle != null) {
                outState.putString(BUNDLE_LAST_PLUGIN_ID_KEY, call.getPluginId());
                outState.putString(BUNDLE_LAST_PLUGIN_CALL_METHOD_NAME_KEY, call.getMethodName());
                outState.putString(BUNDLE_PLUGIN_CALL_OPTIONS_SAVED_KEY, call.getData().toString());
                outState.putBundle(BUNDLE_PLUGIN_CALL_BUNDLE_KEY, bundle);
            } else {
                Logger.error("Couldn't save last " + call.getPluginId() + "'s Plugin " + call.getMethodName() + " call");
            }
        }
    }

    @Deprecated
    public void startActivityForPluginWithResult(PluginCall call, Intent intent, int requestCode) {
        Logger.debug("Starting activity for result");
        this.pluginCallForLastActivity = call;
        this.getActivity().startActivityForResult(intent, requestCode);
    }

    boolean onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        PluginHandle plugin = this.getPluginWithRequestCode(requestCode);
        if (plugin == null) {
            boolean permissionHandled = false;
            Logger.debug("Unable to find a Capacitor plugin to handle permission requestCode, trying Cordova plugins " + requestCode);
            try {
                permissionHandled = this.cordovaInterface.handlePermissionResult(requestCode, permissions, grantResults);
            }
            catch (JSONException e) {
                Logger.debug("Error on Cordova plugin permissions request " + e.getMessage());
            }
            return permissionHandled;
        }
        if (plugin.getPluginAnnotation() == null) {
            plugin.getInstance().handleRequestPermissionsResult(requestCode, permissions, grantResults);
            return true;
        }
        return false;
    }

    protected boolean validatePermissions(Plugin plugin, PluginCall savedCall, Map<String, Boolean> permissions) {
        SharedPreferences prefs = this.getContext().getSharedPreferences(PERMISSION_PREFS_NAME, 0);
        for (Map.Entry<String, Boolean> permission2 : permissions.entrySet()) {
            String permString = permission2.getKey();
            boolean isGranted = permission2.getValue();
            if (isGranted) {
                String state = prefs.getString(permString, null);
                if (state == null) continue;
                SharedPreferences.Editor editor = prefs.edit();
                editor.remove(permString);
                editor.apply();
                continue;
            }
            SharedPreferences.Editor editor = prefs.edit();
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)permString)) {
                editor.putString(permString, PermissionState.PROMPT_WITH_RATIONALE.toString());
            } else {
                editor.putString(permString, PermissionState.DENIED.toString());
            }
            editor.apply();
        }
        String[] permStrings = permissions.keySet().toArray(new String[0]);
        if (!PermissionHelper.hasDefinedPermissions(this.getContext(), permStrings)) {
            String[] missing;
            StringBuilder builder = new StringBuilder();
            builder.append("Missing the following permissions in AndroidManifest.xml:\n");
            for (String perm : missing = PermissionHelper.getUndefinedPermissions(this.getContext(), permStrings)) {
                builder.append(perm + "\n");
            }
            savedCall.reject(builder.toString());
            return false;
        }
        return true;
    }

    protected Map<String, PermissionState> getPermissionStates(Plugin plugin) {
        HashMap<String, PermissionState> permissionsResults = new HashMap<String, PermissionState>();
        CapacitorPlugin annotation = plugin.getPluginHandle().getPluginAnnotation();
        for (Permission perm : annotation.permissions()) {
            if (perm.strings().length == 0 || perm.strings().length == 1 && perm.strings()[0].isEmpty()) {
                PermissionState existingResult;
                String key = perm.alias();
                if (key.isEmpty() || (existingResult = (PermissionState)((Object)permissionsResults.get(key))) != null) continue;
                permissionsResults.put(key, PermissionState.GRANTED);
                continue;
            }
            for (String permString : perm.strings()) {
                PermissionState permissionStatus;
                String key;
                String string2 = key = perm.alias().isEmpty() ? permString : perm.alias();
                if (ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)permString) == 0) {
                    permissionStatus = PermissionState.GRANTED;
                } else {
                    permissionStatus = PermissionState.PROMPT;
                    SharedPreferences prefs = this.getContext().getSharedPreferences(PERMISSION_PREFS_NAME, 0);
                    String state = prefs.getString(permString, null);
                    if (state != null) {
                        permissionStatus = PermissionState.byState(state);
                    }
                }
                PermissionState existingResult = (PermissionState)((Object)permissionsResults.get(key));
                if (existingResult != null && existingResult != PermissionState.GRANTED) continue;
                permissionsResults.put(key, permissionStatus);
            }
        }
        return permissionsResults;
    }

    boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        PluginHandle plugin = this.getPluginWithRequestCode(requestCode);
        if (plugin == null || plugin.getInstance() == null) {
            Logger.debug("Unable to find a Capacitor plugin to handle requestCode, trying Cordova plugins " + requestCode);
            return this.cordovaInterface.onActivityResult(requestCode, resultCode, data);
        }
        PluginCall lastCall = plugin.getInstance().getSavedCall();
        if (lastCall == null && this.pluginCallForLastActivity != null) {
            plugin.getInstance().saveCall(this.pluginCallForLastActivity);
        }
        plugin.getInstance().handleOnActivityResult(requestCode, resultCode, data);
        this.pluginCallForLastActivity = null;
        return true;
    }

    public void onNewIntent(Intent intent) {
        for (PluginHandle plugin : this.plugins.values()) {
            plugin.getInstance().handleOnNewIntent(intent);
        }
        if (this.cordovaWebView != null) {
            this.cordovaWebView.onNewIntent(intent);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        for (PluginHandle plugin : this.plugins.values()) {
            plugin.getInstance().handleOnConfigurationChanged(newConfig);
        }
    }

    public void onRestart() {
        for (PluginHandle plugin : this.plugins.values()) {
            plugin.getInstance().handleOnRestart();
        }
    }

    public void onStart() {
        for (PluginHandle plugin : this.plugins.values()) {
            plugin.getInstance().handleOnStart();
        }
        if (this.cordovaWebView != null) {
            this.cordovaWebView.handleStart();
        }
    }

    public void onResume() {
        for (PluginHandle plugin : this.plugins.values()) {
            plugin.getInstance().handleOnResume();
        }
        if (this.cordovaWebView != null) {
            this.cordovaWebView.handleResume(this.shouldKeepRunning());
        }
    }

    public void onPause() {
        for (PluginHandle plugin : this.plugins.values()) {
            plugin.getInstance().handleOnPause();
        }
        if (this.cordovaWebView != null) {
            boolean keepRunning = this.shouldKeepRunning() || this.cordovaInterface.getActivityResultCallback() != null;
            this.cordovaWebView.handlePause(keepRunning);
        }
    }

    public void onStop() {
        for (PluginHandle plugin : this.plugins.values()) {
            plugin.getInstance().handleOnStop();
        }
        if (this.cordovaWebView != null) {
            this.cordovaWebView.handleStop();
        }
    }

    public void onDestroy() {
        for (PluginHandle plugin : this.plugins.values()) {
            plugin.getInstance().handleOnDestroy();
        }
        this.handlerThread.quitSafely();
        if (this.cordovaWebView != null) {
            this.cordovaWebView.handleDestroy();
        }
    }

    public void onDetachedFromWindow() {
        this.webView.removeAllViews();
        this.webView.destroy();
    }

    public String getServerBasePath() {
        return this.localServer.getBasePath();
    }

    public void setServerBasePath(String path) {
        this.localServer.hostFiles(path);
        this.webView.post(() -> this.webView.loadUrl(this.appUrl));
    }

    public void setServerAssetPath(String path) {
        this.localServer.hostAssets(path);
        this.webView.post(() -> this.webView.loadUrl(this.appUrl));
    }

    public void reload() {
        this.webView.post(() -> this.webView.loadUrl(this.appUrl));
    }

    public String getLocalUrl() {
        return this.localUrl;
    }

    public WebViewLocalServer getLocalServer() {
        return this.localServer;
    }

    public HostMask getAppAllowNavigationMask() {
        return this.appAllowNavigationMask;
    }

    public Set<String> getAllowedOriginRules() {
        return this.allowedOriginRules;
    }

    public BridgeWebViewClient getWebViewClient() {
        return this.webViewClient;
    }

    public void setWebViewClient(BridgeWebViewClient client) {
        this.webViewClient = client;
        this.webView.setWebViewClient((WebViewClient)client);
    }

    List<WebViewListener> getWebViewListeners() {
        return this.webViewListeners;
    }

    void setWebViewListeners(List<WebViewListener> webViewListeners) {
        this.webViewListeners = webViewListeners;
    }

    RouteProcessor getRouteProcessor() {
        return this.routeProcessor;
    }

    void setRouteProcessor(RouteProcessor routeProcessor) {
        this.routeProcessor = routeProcessor;
    }

    ServerPath getServerPath() {
        return this.serverPath;
    }

    public void addWebViewListener(WebViewListener webViewListener) {
        this.webViewListeners.add(webViewListener);
    }

    public void removeWebViewListener(WebViewListener webViewListener) {
        this.webViewListeners.remove(webViewListener);
    }

    public static class Builder {
        private Bundle instanceState = null;
        private CapConfig config = null;
        private List<Class<? extends Plugin>> plugins = new ArrayList<Class<? extends Plugin>>();
        private List<Plugin> pluginInstances = new ArrayList<Plugin>();
        private AppCompatActivity activity;
        private Fragment fragment;
        private RouteProcessor routeProcessor;
        private final List<WebViewListener> webViewListeners = new ArrayList<WebViewListener>();
        private ServerPath serverPath;

        public Builder(AppCompatActivity activity) {
            this.activity = activity;
        }

        public Builder(Fragment fragment) {
            this.activity = (AppCompatActivity)fragment.getActivity();
            this.fragment = fragment;
        }

        public Builder setInstanceState(Bundle instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        public Builder setConfig(CapConfig config) {
            this.config = config;
            return this;
        }

        public Builder setPlugins(List<Class<? extends Plugin>> plugins) {
            this.plugins = plugins;
            return this;
        }

        public Builder addPlugin(Class<? extends Plugin> plugin) {
            this.plugins.add(plugin);
            return this;
        }

        public Builder addPlugins(List<Class<? extends Plugin>> plugins) {
            for (Class<? extends Plugin> cls : plugins) {
                this.addPlugin(cls);
            }
            return this;
        }

        public Builder addPluginInstance(Plugin plugin) {
            this.pluginInstances.add(plugin);
            return this;
        }

        public Builder addPluginInstances(List<Plugin> plugins) {
            this.pluginInstances.addAll(plugins);
            return this;
        }

        public Builder addWebViewListener(WebViewListener webViewListener) {
            this.webViewListeners.add(webViewListener);
            return this;
        }

        public Builder addWebViewListeners(List<WebViewListener> webViewListeners) {
            for (WebViewListener listener : webViewListeners) {
                this.addWebViewListener(listener);
            }
            return this;
        }

        public Builder setRouteProcessor(RouteProcessor routeProcessor) {
            this.routeProcessor = routeProcessor;
            return this;
        }

        public Builder setServerPath(ServerPath serverPath) {
            this.serverPath = serverPath;
            return this;
        }

        public Bridge create() {
            ConfigXmlParser parser = new ConfigXmlParser();
            parser.parse(this.activity.getApplicationContext());
            CordovaPreferences preferences = parser.getPreferences();
            preferences.setPreferencesBundle(this.activity.getIntent().getExtras());
            ArrayList pluginEntries = parser.getPluginEntries();
            MockCordovaInterfaceImpl cordovaInterface = new MockCordovaInterfaceImpl(this.activity);
            if (this.instanceState != null) {
                cordovaInterface.restoreInstanceState(this.instanceState);
            }
            android.webkit.WebView webView = this.fragment != null ? (android.webkit.WebView)this.fragment.getView().findViewById(R.id.webview) : (android.webkit.WebView)this.activity.findViewById(R.id.webview);
            MockCordovaWebViewImpl mockWebView = new MockCordovaWebViewImpl(this.activity.getApplicationContext());
            mockWebView.init((CordovaInterface)cordovaInterface, pluginEntries, preferences, webView);
            PluginManager pluginManager = mockWebView.getPluginManager();
            cordovaInterface.onCordovaInit(pluginManager);
            Bridge bridge = new Bridge(this.activity, this.serverPath, this.fragment, webView, this.plugins, this.pluginInstances, cordovaInterface, pluginManager, preferences, this.config);
            if (webView instanceof CapacitorWebView) {
                CapacitorWebView capacitorWebView = (CapacitorWebView)webView;
                capacitorWebView.setBridge(bridge);
            }
            bridge.setCordovaWebView(mockWebView);
            bridge.setWebViewListeners(this.webViewListeners);
            bridge.setRouteProcessor(this.routeProcessor);
            if (this.instanceState != null) {
                bridge.restoreInstanceState(this.instanceState);
            }
            return bridge;
        }
    }
}

