/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import com.getcapacitor.Bridge;
import com.getcapacitor.InvalidPluginException;
import com.getcapacitor.InvalidPluginMethodException;
import com.getcapacitor.NativePlugin;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginLoadException;
import com.getcapacitor.PluginMethod;
import com.getcapacitor.PluginMethodHandle;
import com.getcapacitor.annotation.CapacitorPlugin;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PluginHandle {
    private final Bridge bridge;
    private final Class<? extends Plugin> pluginClass;
    private final Map<String, PluginMethodHandle> pluginMethods = new HashMap<String, PluginMethodHandle>();
    private final String pluginId;
    private NativePlugin legacyPluginAnnotation;
    private CapacitorPlugin pluginAnnotation;
    private Plugin instance;

    private PluginHandle(Class<? extends Plugin> clazz, Bridge bridge) throws InvalidPluginException {
        this.bridge = bridge;
        this.pluginClass = clazz;
        CapacitorPlugin pluginAnnotation = this.pluginClass.getAnnotation(CapacitorPlugin.class);
        if (pluginAnnotation == null) {
            NativePlugin legacyPluginAnnotation = this.pluginClass.getAnnotation(NativePlugin.class);
            if (legacyPluginAnnotation == null) {
                throw new InvalidPluginException("No @CapacitorPlugin annotation found for plugin " + this.pluginClass.getName());
            }
            this.pluginId = !legacyPluginAnnotation.name().equals("") ? legacyPluginAnnotation.name() : this.pluginClass.getSimpleName();
            this.legacyPluginAnnotation = legacyPluginAnnotation;
        } else {
            this.pluginId = !pluginAnnotation.name().equals("") ? pluginAnnotation.name() : this.pluginClass.getSimpleName();
            this.pluginAnnotation = pluginAnnotation;
        }
        this.indexMethods(clazz);
    }

    public PluginHandle(Bridge bridge, Class<? extends Plugin> pluginClass) throws InvalidPluginException, PluginLoadException {
        this(pluginClass, bridge);
        this.load();
    }

    public PluginHandle(Bridge bridge, Plugin plugin) throws InvalidPluginException {
        this(plugin.getClass(), bridge);
        this.loadInstance(plugin);
    }

    public Class<? extends Plugin> getPluginClass() {
        return this.pluginClass;
    }

    public String getId() {
        return this.pluginId;
    }

    public NativePlugin getLegacyPluginAnnotation() {
        return this.legacyPluginAnnotation;
    }

    public CapacitorPlugin getPluginAnnotation() {
        return this.pluginAnnotation;
    }

    public Plugin getInstance() {
        return this.instance;
    }

    public Collection<PluginMethodHandle> getMethods() {
        return this.pluginMethods.values();
    }

    public Plugin load() throws PluginLoadException {
        if (this.instance != null) {
            return this.instance;
        }
        try {
            this.instance = this.pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return this.loadInstance(this.instance);
        }
        catch (Exception ex) {
            throw new PluginLoadException("Unable to load plugin instance. Ensure plugin is publicly accessible");
        }
    }

    public Plugin loadInstance(Plugin plugin) {
        this.instance = plugin;
        this.instance.setPluginHandle(this);
        this.instance.setBridge(this.bridge);
        this.instance.load();
        this.instance.initializeActivityLaunchers();
        return this.instance;
    }

    public void invoke(String methodName, PluginCall call) throws PluginLoadException, InvalidPluginMethodException, InvocationTargetException, IllegalAccessException {
        PluginMethodHandle methodMeta;
        if (this.instance == null) {
            this.load();
        }
        if ((methodMeta = this.pluginMethods.get(methodName)) == null) {
            throw new InvalidPluginMethodException("No method " + methodName + " found for plugin " + this.pluginClass.getName());
        }
        methodMeta.getMethod().invoke((Object)this.instance, call);
    }

    private void indexMethods(Class<? extends Plugin> plugin) {
        Method[] methods;
        for (Method methodReflect : methods = this.pluginClass.getMethods()) {
            PluginMethod method = methodReflect.getAnnotation(PluginMethod.class);
            if (method == null) continue;
            PluginMethodHandle methodMeta = new PluginMethodHandle(methodReflect, method);
            this.pluginMethods.put(methodReflect.getName(), methodMeta);
        }
    }
}

