/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import androidx.webkit.JavaScriptReplyProxy;
import androidx.webkit.WebViewCompat;
import androidx.webkit.WebViewFeature;
import com.getcapacitor.Bridge;
import com.getcapacitor.JSObject;
import com.getcapacitor.Logger;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginResult;
import org.apache.cordova.PluginManager;

public class MessageHandler {
    private Bridge bridge;
    private WebView webView;
    private PluginManager cordovaPluginManager;
    private JavaScriptReplyProxy javaScriptReplyProxy;

    public MessageHandler(Bridge bridge, WebView webView, PluginManager cordovaPluginManager) {
        this.bridge = bridge;
        this.webView = webView;
        this.cordovaPluginManager = cordovaPluginManager;
        if (WebViewFeature.isFeatureSupported((String)"WEB_MESSAGE_LISTENER") && !bridge.getConfig().isUsingLegacyBridge()) {
            WebViewCompat.WebMessageListener capListener = (view, message, sourceOrigin, isMainFrame, replyProxy) -> {
                if (isMainFrame) {
                    this.postMessage(message.getData());
                    this.javaScriptReplyProxy = replyProxy;
                } else {
                    Logger.warn("Plugin execution is allowed in Main Frame only");
                }
            };
            try {
                WebViewCompat.addWebMessageListener((WebView)webView, (String)"androidBridge", bridge.getAllowedOriginRules(), (WebViewCompat.WebMessageListener)capListener);
            }
            catch (Exception ex) {
                webView.addJavascriptInterface((Object)this, "androidBridge");
            }
        } else {
            webView.addJavascriptInterface((Object)this, "androidBridge");
        }
    }

    @JavascriptInterface
    public void postMessage(String jsonStr) {
        try {
            JSObject postData = new JSObject(jsonStr);
            String type = postData.getString("type");
            boolean typeIsNotNull = type != null;
            boolean isCordovaPlugin = typeIsNotNull && type.equals("cordova");
            boolean isJavaScriptError = typeIsNotNull && type.equals("js.error");
            String callbackId = postData.getString("callbackId");
            if (isCordovaPlugin) {
                String service = postData.getString("service");
                String action = postData.getString("action");
                String actionArgs = postData.getString("actionArgs");
                Logger.verbose(Logger.tags("Plugin"), "To native (Cordova plugin): callbackId: " + callbackId + ", service: " + service + ", action: " + action + ", actionArgs: " + actionArgs);
                this.callCordovaPluginMethod(callbackId, service, action, actionArgs);
            } else if (isJavaScriptError) {
                Logger.error("JavaScript Error: " + jsonStr);
            } else {
                String pluginId = postData.getString("pluginId");
                String methodName = postData.getString("methodName");
                JSObject methodData = postData.getJSObject("options", new JSObject());
                Logger.verbose(Logger.tags("Plugin"), "To native (Capacitor plugin): callbackId: " + callbackId + ", pluginId: " + pluginId + ", methodName: " + methodName);
                this.callPluginMethod(callbackId, pluginId, methodName, methodData);
            }
        }
        catch (Exception ex) {
            Logger.error("Post message error:", ex);
        }
    }

    public void sendResponseMessage(PluginCall call, PluginResult successResult, PluginResult errorResult) {
        try {
            boolean isValidCallbackId;
            boolean pluginResultInError;
            PluginResult data = new PluginResult();
            data.put("save", call.isKeptAlive());
            data.put("callbackId", call.getCallbackId());
            data.put("pluginId", call.getPluginId());
            data.put("methodName", call.getMethodName());
            boolean bl = pluginResultInError = errorResult != null;
            if (pluginResultInError) {
                data.put("success", false);
                data.put("error", errorResult);
                Logger.debug("Sending plugin error: " + data.toString());
            } else {
                data.put("success", true);
                if (successResult != null) {
                    data.put("data", successResult);
                }
            }
            boolean bl2 = isValidCallbackId = !call.getCallbackId().equals("-1");
            if (isValidCallbackId) {
                if (this.bridge.getConfig().isUsingLegacyBridge()) {
                    this.legacySendResponseMessage(data);
                } else if (WebViewFeature.isFeatureSupported((String)"WEB_MESSAGE_LISTENER") && this.javaScriptReplyProxy != null) {
                    this.javaScriptReplyProxy.postMessage(data.toString());
                } else {
                    this.legacySendResponseMessage(data);
                }
            } else {
                this.bridge.getApp().fireRestoredResult(data);
            }
        }
        catch (Exception ex) {
            Logger.error("sendResponseMessage: error: " + ex);
        }
        if (!call.isKeptAlive()) {
            call.release(this.bridge);
        }
    }

    private void legacySendResponseMessage(PluginResult data) {
        String runScript = "window.Capacitor.fromNative(" + data.toString() + ")";
        WebView webView = this.webView;
        webView.post(() -> webView.evaluateJavascript(runScript, null));
    }

    private void callPluginMethod(String callbackId, String pluginId, String methodName, JSObject methodData) {
        PluginCall call = new PluginCall(this, pluginId, callbackId, methodName, methodData);
        this.bridge.callPluginMethod(pluginId, methodName, call);
    }

    private void callCordovaPluginMethod(String callbackId, String service, String action, String actionArgs) {
        this.bridge.execute(() -> this.cordovaPluginManager.exec(service, action, callbackId, actionArgs));
    }
}

