/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class JSObject
extends JSONObject {
    public JSObject() {
    }

    public JSObject(String json) throws JSONException {
        super(json);
    }

    public JSObject(JSONObject obj, String[] names) throws JSONException {
        super(obj, names);
    }

    public static JSObject fromJSONObject(JSONObject obj) throws JSONException {
        Iterator keysIter = obj.keys();
        ArrayList<String> keys = new ArrayList<String>();
        while (keysIter.hasNext()) {
            keys.add((String)keysIter.next());
        }
        return new JSObject(obj, keys.toArray(new String[keys.size()]));
    }

    @Nullable
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Nullable
    public String getString(String key, @Nullable String defaultValue) {
        try {
            String value = super.getString(key);
            if (!super.isNull(key)) {
                return value;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return defaultValue;
    }

    @Nullable
    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    @Nullable
    public Integer getInteger(String key, @Nullable Integer defaultValue) {
        try {
            return super.getInt(key);
        }
        catch (JSONException jSONException) {
            return defaultValue;
        }
    }

    @Nullable
    public Boolean getBoolean(String key, @Nullable Boolean defaultValue) {
        try {
            return super.getBoolean(key);
        }
        catch (JSONException jSONException) {
            return defaultValue;
        }
    }

    @Nullable
    public Boolean getBool(String key) {
        return this.getBoolean(key, null);
    }

    @Nullable
    public JSObject getJSObject(String name) {
        try {
            return this.getJSObject(name, null);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Nullable
    public JSObject getJSObject(String name, @Nullable JSObject defaultValue) throws JSONException {
        try {
            Object obj = this.get(name);
            if (obj instanceof JSONObject) {
                Iterator keysIter = ((JSONObject)obj).keys();
                ArrayList<String> keys = new ArrayList<String>();
                while (keysIter.hasNext()) {
                    keys.add((String)keysIter.next());
                }
                return new JSObject((JSONObject)obj, keys.toArray(new String[keys.size()]));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return defaultValue;
    }

    public JSObject put(String key, boolean value) {
        try {
            super.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public JSObject put(String key, int value) {
        try {
            super.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public JSObject put(String key, long value) {
        try {
            super.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public JSObject put(String key, double value) {
        try {
            super.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public JSObject put(String key, Object value) {
        try {
            super.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public JSObject put(String key, String value) {
        try {
            super.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public JSObject putSafe(String key, Object value) throws JSONException {
        return (JSObject)super.put(key, value);
    }
}

